package com.jfb.recruit.controller.api;

import com.jfb.recruit.service.IndustryService;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Industry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import util.CommonUtils;
import util.MultipartFileToFile;
import util.excel.ExcelXlsxReader;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.List;
import java.util.Map;

/**
 * 日结名单导入
 * @author: wangmenglong
 * @date: 2021/7/26
 */
@RestController
@RequestMapping(value = "/import/industry")
public class ImportIndustryController {

    @Autowired
    IndustryService industryService;

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
     * 日结名单导入
     * @param: [req]
     * @return: util.BaseResult
     * @author: wangmenglong
     * @date: 2021/7/13
     */
    @RequestMapping(value = "/upload", method = RequestMethod.POST)
    public void uploadEntryFile(HttpServletRequest req, @RequestParam(value = "file", required = false) MultipartFile multipartFile) {

        try {
            File file = MultipartFileToFile.multipartFileToFile(multipartFile);
            ExcelXlsxReader excelXlsxReader = new ExcelXlsxReader();
            Map<String, List<List<String>>> map = excelXlsxReader.process(file);
            List<List<String>> rowList = map.get("1");
            rowList.remove(0);

            for (List<String> colList : rowList) {

                Thread.sleep(100);

                //获取每行数据
                Industry industry=new Industry();

                String oneName =  CommonUtils.replaceBlank(colList.get(0));
                String oneSort = CommonUtils.replaceBlank(colList.get(1));
                String twoName = CommonUtils.replaceBlank(colList.get(2));
                String twoSort = CommonUtils.replaceBlank(colList.get(3));
                String name = CommonUtils.replaceBlank(colList.get(4));
                String code = CommonUtils.replaceBlank(colList.get(5));


                Industry oneindustry =  industryService.getDetailsByName(oneName,"0");
                Industry twoindustry =  industryService.getDetailsByName(twoName,"1");

                if(oneindustry== null){
                    oneindustry = new Industry();
                    oneindustry.setId(snowFlakeFactory.nextId());
                    oneindustry.setParentId("0");
                    oneindustry.setSort(Integer.parseInt(oneSort));
                    oneindustry.setName(oneName);
                    industryService.create(oneindustry);

                }

                if(twoindustry== null){
                    twoindustry = new Industry();
                    twoindustry.setId(snowFlakeFactory.nextId());
                    twoindustry.setParentId("0");
                    twoindustry.setSort(Integer.parseInt(twoSort));
                    twoindustry.setParentId(oneindustry.getId());
                    twoindustry.setName(twoName);
                    industryService.create(twoindustry);
                }

                industry = new Industry();
                industry.setId(snowFlakeFactory.nextId());
                industry.setParentId("0");
                industry.setCode(code);
                industry.setName(name);
                industry.setParentId(twoindustry.getId());
                industryService.create(industry);

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
