package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.SignRecordService;
import com.jfb.recruit.service.RecruitService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.SignRecord;
import data.recruit.Recruit;
import excel.ExportRecruit;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import static org.reflections.Reflections.log;

/**
 * @author wangmenglong
 * @description: 报名管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/signRecord")
public class SignRecordController extends BaseController {

    @Resource
    SignRecordService signRecordService;

    @Resource
    RecruitService recruitService;

    /**
     * @description: 获取报名列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        List<Recruit> list = recruitService.listBySignRecord(pageNum,pageSize,userContext.getUserId());
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * @description: 获取报名列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/admin/list")
    public BaseResult adminList(HttpServletRequest req){
        PageInit(req);
        String personIdno = req.getParameter("personIdno");
        String personName = req.getParameter("personName");
        String name = req.getParameter("name");
        String userName = req.getParameter("userName");
        List<Recruit> list = recruitService.listBySignRecordAdmin(pageNum,pageSize,personIdno,personName,name,userName);
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * 导出明细
     * @param: [req]
     * @return: util.Paging
     * @author: wangmenglong
     * @date: 2021/7/13
     */
    @RequestMapping(value = "/admin/list/export", method = RequestMethod.POST)
    @ResponseBody
    public void export(HttpServletRequest req, HttpServletResponse response) {

        PageInit(req);
        String personIdno = req.getParameter("personIdno");
        String personName = req.getParameter("personName");
        String name = req.getParameter("name");
        String userName = req.getParameter("userName");
        List<Recruit> list = recruitService.listBySignRecordAdmin(pageNum,pageSize,personIdno,personName,name,userName);

        try {
            //导出数据
            String now = DateFormatUtils.format(new Date(), "yyyyMMddHHmmss");
            response.setHeader("Access-Control-Allow-Origin", "*");
            if (req.getMethod().equals("OPTIONS")) {
                response.addHeader("Access-Control-Allow-Methods", "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,PATCH");
                response.addHeader("Access-Control-Allow-Headers", "dnt,Origin, X-Requested-With,Content-Type, Accept, Authorization");
            }
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            String encodedFileName = URLEncoder.encode("求职报名"+now, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment; filename*=UTF-8''" + encodedFileName);

            ExcelWriter excelWriter = EasyExcel.write(response.getOutputStream()).build();

            List<ExportRecruit> result = new ArrayList<>();

            list.stream().forEach(item->{
                ExportRecruit exportRecruit = new ExportRecruit();
                exportRecruit.setRtTime(item.getRtTime());
                exportRecruit.setOrgName(item.getOrgName());
                exportRecruit.setName(item.getName());
                exportRecruit.setPersonName(item.getPerson().getName());
                exportRecruit.setPersonPhoneNumber(item.getPerson().getPhoneNumber());
                if (item.getPerson().getSex() != null){
                    if (item.getPerson().getSex()){
                        exportRecruit.setPersonSex("男");
                    } else {
                        exportRecruit.setPersonSex("女");
                    }
                }
                exportRecruit.setPersonIdNo(item.getPerson().getIdNo());

                switch (item.getRecordState()){
                    case "INTERVIEW":
                        exportRecruit.setRecordState("面试中");
                        break;
                    case "APPLY_FAILED":
                        exportRecruit.setRecordState("未录取");
                        break;
                    case "APPLY_SUCCESS":
                        exportRecruit.setRecordState("已录取");
                        break;
                    case "ON_BOARDING":
                        exportRecruit.setRecordState("已入职");
                        break;
                    case "INVITING_INTERVIEW":
                        exportRecruit.setRecordState("邀请面试");
                        break;
                    case "APPLYING":
                        exportRecruit.setRecordState("提交简历");
                        break;
                }

                exportRecruit.setUserName(item.getUserName());
                exportRecruit.setCreateTime(item.getCreateTime());
                result.add(exportRecruit);
            });


            WriteSheet bill = EasyExcel.writerSheet(0,"求职报名").head(ExportRecruit.class)
                    .build();
            excelWriter.write(result, bill);

            excelWriter.finish();
        } catch (Exception e) {
            log.error("附加扣除导出数据失败", e);
        }

    }

    /**
    * @description: 新增报名
    * @author: wangmenglong
    * @param: [signRecord]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody SignRecord signRecord){

        UserContext userContext = UserUtils.getUserContext();
        signRecord.setUserId(userContext.getUserId());
        signRecord.setPersonId(userContext.getUserId());
        signRecord.setBaseCode(userContext.getBaseCode());

        //判断是否重复
        if(signRecordService.isHave(signRecord.getRecruitId(),signRecord.getPersonId())){
            signRecordService.del(signRecord.getRecruitId(),signRecord.getPersonId());
        }else {
            signRecordService.create(signRecord);
        }
        return BaseResult.success("normal_001");
    }

    /**
     * @description: 是否报名
     * @author: wangmenglong
     * @param: [signRecord]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/have")
    public BaseResult have(@RequestBody SignRecord signRecord){

        UserContext userContext = UserUtils.getUserContext();
        signRecord.setUserId(userContext.getUserId());
        signRecord.setPersonId(userContext.getUserId());

        //判断是否重复
        if(signRecordService.isHave(signRecord.getRecruitId(),signRecord.getPersonId())){
            return BaseResult.success("normal_001","1");
        }else {
            return BaseResult.success("normal_001","0");
        }
    }

}
