package excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.alibaba.excel.annotation.write.style.HeadStyle;
import lombok.Data;
import org.apache.poi.ss.usermodel.FillPatternType;

import java.math.BigDecimal;

/**
 * @author wangmenglong
 * @description: 报名导出
 * @date 2024/6/21 16:45
 */
@Data
@HeadRowHeight(20)
@HeadStyle(fillPatternType = FillPatternType.SOLID_FOREGROUND, fillForegroundColor = 22)
@HeadFontStyle(fontHeightInPoints = 11)
@ColumnWidth(25)
public class ExportRecruit {


    @ExcelProperty("报名时间")
    private String rtTime;

    @ExcelProperty("报名企业")
    private String orgName;

    @ExcelProperty("报名职位")
    private String name;

    @ExcelProperty("姓名")
    private String personName;

    @ExcelProperty("联系电话")
    private String personPhoneNumber;

    @ExcelProperty("性别")
    private String personSex;

    @ExcelProperty("身份证号")
    private String personIdNo;

    @ExcelProperty("状态")
    private String recordState;

    @ExcelProperty("岗位发布人")
    private String userName;

    @ExcelProperty("创建时间")
    private String createTime;


}
