package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.ObjectiveMapper;
import com.jfb.recruit.service.ObjectiveService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Objective;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 求职意向管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class ObjectiveServiceImpl extends ServiceImpl<ObjectiveMapper, Objective> implements ObjectiveService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
     * @description: 获取求职意向列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.objective.Objective>
     **/
    @Override
    public List<Objective> list(int pageNum, int pageSize, Objective objective) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Objective> qw = new LambdaQueryWrapper<>();
        qw.eq(Objective::getDel,false)
                .eq(StringUtils.isNotBlank(objective.getBaseCode()),Objective::getBaseCode, objective.getBaseCode())
                .eq(StringUtils.isNotBlank(objective.getPersonId()),Objective::getPersonId, objective.getPersonId())
                .orderByDesc(Objective::getCreateTime);
        List<Objective> objectiveList = super.list(qw);
        //返回查询结果
        return objectiveList;
    }


    /**
     * @description: 新增求职意向
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [objective]
     * @return: boolean
     **/
    @Override
    public boolean create(Objective objective) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        objective.setId(snowFlakeFactory.nextId());
        objective.setBaseCode(baseCode);
        objective.setDel(false);
        objective.setCreateTime(DateUtil.now());

        return super.save(objective);
    }

    /**
     * @description: 编辑求职意向
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [objective]
     * @return: boolean
     **/
    @Override
    public boolean update(Objective objective) {
        objective.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(objective.getId())){
            return false;
        }
        return super.saveOrUpdate(objective);
    }

    /**
     * @description: 删除求职意向
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Objective> qw = new LambdaUpdateWrapper<>();
        qw.eq(Objective::getId,id)
                .set(Objective::getDel,true)
                .set(Objective::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取求职意向详情
     * @param: [id]
     * @return: data.objective.Objective
     **/
    @Override
    public Objective getDetails(String id) {
        return super.getById(id);
    }

}
