package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.IndustryMapper;
import com.jfb.recruit.service.IndustryService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Industry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 行业管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class IndustryServiceImpl extends ServiceImpl<IndustryMapper, Industry> implements IndustryService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取行业列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.industry.Industry>
     **/
    @Override
    public List<Industry> list(int pageNum, int pageSize, Industry industry) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Industry> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(industry.getName()),Industry::getName,industry.getName())
                .eq(Industry::getDel,false)
                .eq(StringUtils.isNotBlank(industry.getBaseCode()),Industry::getBaseCode, industry.getBaseCode())
                .orderByDesc(Industry::getCreateTime);
        List<Industry> industryList = super.list(qw);
        //返回查询结果
        return industryList;
    }

    /**
     * @description: 获取行业列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.industry.Industry>
     **/
    @Override
    public List<Industry> listAll(Industry industry) {
        //创建查询条件
        LambdaQueryWrapper<Industry> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(industry.getName()),Industry::getName,industry.getName())
                .eq(Industry::getDel,false)
                .eq(StringUtils.isNotBlank(industry.getBaseCode()),Industry::getBaseCode, industry.getBaseCode())
                .orderByDesc(Industry::getCreateTime);
        List<Industry> industryList = super.list(qw);
        //返回查询结果
        return industryList;
    }


    /**
     * @description: 新增行业
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [industry]
     * @return: boolean
     **/
    @Override
    public boolean create(Industry industry) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        industry.setId(snowFlakeFactory.nextId());
        industry.setBaseCode(baseCode);
        industry.setDel(false);
        industry.setCreateTime(DateUtil.now());

        return super.save(industry);
    }

    /**
     * @description: 编辑行业
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [industry]
     * @return: boolean
     **/
    @Override
    public boolean update(Industry industry) {
        industry.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(industry.getId())){
            return false;
        }
        return super.saveOrUpdate(industry);
    }

    /**
     * @description: 删除行业
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Industry> qw = new LambdaUpdateWrapper<>();
        qw.eq(Industry::getId,id)
                .set(Industry::getDel,true)
                .set(Industry::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取行业详情
     * @param: [id]
     * @return: data.industry.Industry
     **/
    @Override
    public Industry getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String name, String id) {
        LambdaQueryWrapper<Industry> qw = new LambdaQueryWrapper<>();
        qw.eq(Industry::getDel,false)
                .eq(Industry::getName, name);
        //如果传了id就是编辑，编辑的时候要加个条件，不能把名字跟别人重复
        if(StringUtils.isNotBlank(id)){
            qw.ne(Industry::getId,id);
        }
        return super.count(qw)>0;
    }
}
