package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.ObjectiveIndustryService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.ObjectiveIndustry;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 意向行业管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/objectiveIndustry")
public class ObjectiveIndustryController extends BaseController {

    @Resource
    ObjectiveIndustryService objectiveIndustryService;

    /**
     * @description: 获取意向行业列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l/all")
    public BaseResult listAll(HttpServletRequest req,ObjectiveIndustry objectiveIndustry){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        objectiveIndustry.setBaseCode(userContext.getBaseCode());
        List<ObjectiveIndustry> list = objectiveIndustryService.listAll(objectiveIndustry);
        PageInfo<ObjectiveIndustry> pageInfo = new PageInfo<ObjectiveIndustry>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增意向行业
    * @author: wangmenglong
    * @param: [objectiveIndustry]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody ObjectiveIndustry objectiveIndustry){
        //判断是否重复
        if(objectiveIndustryService.isHave(objectiveIndustry.getPersonId(),objectiveIndustry.getIndustryId())){
            return BaseResult.error("error_007");
        }
        return objectiveIndustryService.create(objectiveIndustry)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }


    /**
     * @description: 删除意向行业
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return objectiveIndustryService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

}
