package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.IndustryService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Industry;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 行业管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/industry")
public class IndustryController extends BaseController {

    @Resource
    IndustryService industryService;

    /**
     * @description: 获取行业列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Industry industry){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        industry.setBaseCode(userContext.getBaseCode());
        List<Industry> list = industryService.list(pageNum,pageSize,industry);
        PageInfo<Industry> pageInfo = new PageInfo<Industry>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * @description: 获取行业列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l/all")
    public BaseResult listAll(HttpServletRequest req,Industry industry){
        UserContext userContext = UserUtils.getUserContext();
        industry.setBaseCode(userContext.getBaseCode());
        List<Industry> list = industryService.list(pageNum,pageSize,industry);
        return BaseResult.success(list);
    }



    /**
    * @description: 新增行业
    * @author: wangmenglong
    * @param: [industry]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Industry industry){
        //判断是否重复
        if(industryService.isHave(industry.getName(),industry.getId())){
            return BaseResult.error("error_006");
        }
        return industryService.create(industry)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑行业
     * @author: wangmenglong
     * @param: [industry]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Industry industry){
        //判断是否重复
        if(industryService.isHave(industry.getName(),industry.getId())){
            return BaseResult.error("error_006");
        }
        return industryService.update(industry)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除行业
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return industryService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取行业详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Industry industry = industryService.getDetails(id);
        return BaseResult.success(industry);
    }

    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:18
     * @description: 获取行业详情
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @GetMapping("/industry/details")
    public BaseResult details(){
        UserContext userContext = UserUtils.getUserContext();
        Industry industry = industryService.getDetails(userContext.getUserId());
        return BaseResult.success(industry);
    }
}
