package util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

/**
 * @author yuetianwang
 * @description 加密工具类
 * @date 2021/8/4 18:38
 */
public class CryptoUtil {

    public static final String SALT = "K2mQCycm";

    /**
     * 加盐签名
     *
     * @param map 签名的数据
     * @return
     */
    public static String SHA256(String slat, TreeMap<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        map.forEach((k, v) -> {
            sb.append(k).append("=").append("v");
            sb.append("&");
        });
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(slat);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(sb.toString().getBytes(StandardCharsets.UTF_8));
            byte[] digest = messageDigest.digest();
            return byte2Hex(digest);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 校验加盐签名
     *
     * @param map  签名的数据
     * @param sign 比对的签名
     * @return
     */
    public static boolean SHA256Validate(String slat, TreeMap<String, Object> map, String sign) {
        String otherSign = SHA256(slat, map);
        return Objects.equals(sign, otherSign);
    }

    /**
     * 将byte转为16进制
     *
     * @param bytes
     * @return
     */
    private static String byte2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String temp = null;
        for (int i = 0; i < bytes.length; i++) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                //1得到一位的进行补0操作
                sb.append("0");
            }
            sb.append(temp);
        }
        return sb.toString();
    }
}
