package com.jfb.recruit.handler.auth;

import com.jfb.recruit.util.auth.ResultUtil;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Component
public class UserAuthenticationEntryPointHandler implements AuthenticationEntryPoint {
    /**
     * 用户未登录返回结果
     *
     * @param request
     * @param response
     * @param exception
     * @return
     * @author wangmenglong
     * @date 2020/4/4
     **/
    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        ResultUtil.responseJson(response, ResultUtil.resultCode(401, "未登录"));
    }
}
