package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.PersonService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Person;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 人员管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/person")
public class PersonController extends BaseController {

    @Resource
    PersonService personService;

    /**
     * @description: 获取人员列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,Person person){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        person.setBaseCode(userContext.getBaseCode());
        List<Person> list = personService.list(pageNum,pageSize,person);
        PageInfo<Person> pageInfo = new PageInfo<Person>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增人员
    * @author: wangmenglong
    * @param: [person]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Person person){
        //判断是否重复
        if(personService.isHave(person.getOpenId(),person.getId())){
            return BaseResult.error("error_005");
        }
        return personService.create(person)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑人员
     * @author: wangmenglong
     * @param: [person]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Person person){
        //判断是否重复
        if(personService.isHave(person.getOpenId(),person.getId())){
            return BaseResult.error("error_005");
        }
        return personService.update(person)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除人员
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return personService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取人员详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Person person = personService.getDetails(id);
        return BaseResult.success(person);
    }

    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:18
     * @description: 获取人员详情
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @GetMapping("/person/details")
    public BaseResult details(){
        UserContext userContext = UserUtils.getUserContext();
        Person person = personService.getDetails(userContext.getUserId());
        return BaseResult.success(person);
    }
}
