package com.cm_crm.util.auth;

import com.alibaba.fastjson.JSON;
import com.cm_crm.bean.auth.SelfUserEntity;
import com.cm_crm.config.auth.JWTConfig;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.springframework.core.io.ClassPathResource;

import java.io.InputStream;
import java.util.Date;

public class JWTTokenUtil {

    /**
     * 私有化构造器
     */
    private JWTTokenUtil(){}

    /**
     * 生成Token
     * @author wml
     * @date 2020/4/4
     * @param selfUserEntity
     * @return
     **/
    public static String createAccessToken(SelfUserEntity selfUserEntity){

        String provider="";
        try {

            ClassPathResource classPathResource = new ClassPathResource("cm-crm-jwt.jks");
            InputStream inputStream =classPathResource.getInputStream();

            ExportPrivateKey export=new ExportPrivateKey();
            export.keystoreFile=inputStream;
            export.keyStoreType="JKS";
            export.password= JWTConfig.secret.toCharArray();
            export.alias="cm-crm-jwt";
            //export.exportedFile=new File("luke");
            provider=export.export();

        } catch (Exception e) {
            System.out.println("Token无效1");
            return null;
        }


        // 登陆成功生成JWT
        String token = Jwts.builder()
                // 放入用户名和用户ID
                .setId(selfUserEntity.getUserId()+"")
                // 主题
                .setSubject(selfUserEntity.getUsername())
                // 签发时间
                .setIssuedAt(new Date())
                // 签发者
                .setIssuer("sans")
                // 自定义属性 放入用户拥有权限/派遣公司
                .claim("authorities", JSON.toJSONString(selfUserEntity.getAuthorities()))
                .claim("baseCode",selfUserEntity.getBaseCode())
                .claim("type",selfUserEntity.getType())
                .claim("name",selfUserEntity.getName())
                .claim("roleId",selfUserEntity.getRoleId())
                .claim("roleTag",selfUserEntity.getRoleTag())
                .claim("idNo",selfUserEntity.getIdNo())
                .claim("openId",selfUserEntity.getOpenId())
                .claim("phone", selfUserEntity.getPhone())
                .claim("superAdmin", selfUserEntity.getSuperAdmin())
                // 失效时间
                .setExpiration(new Date(System.currentTimeMillis() + JWTConfig.expiration))
                // 签名算法和密钥
                .signWith(SignatureAlgorithm.HS512, provider)
                .compact();
        return token;
    }


}
