package com.cm_crm.util.auth;

import com.cm_crm.service.UserService;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * @author wangmenglong
 * @description: TODO
 * @date 2024/1/31 16:51
 */
@Component
@Getter
public class InjectUtil {


    @Autowired
    private UserService userService;


    @PostConstruct
    public void init(){
        InjectUtil.getInstance().userService = this.userService;
    }


    //实现单例 start
    private static class SingletonHolder {
        private static final InjectUtil INSTANCE = new InjectUtil();
    }
    private InjectUtil(){}
    public static final InjectUtil getInstance() {
        return SingletonHolder.INSTANCE;
    }
    //实现单例 end

}
