package com.cm_crm.util.auth;

import sun.misc.BASE64Encoder;

import java.io.File;
import java.io.InputStream;
import java.security.*;
import java.security.cert.Certificate;

public class ExportPrivateKey {
    public InputStream keystoreFile;
    public String keyStoreType;
    public char[] password;
    public String alias;
    public File exportedFile;
    public static KeyPair getPrivateKey(KeyStore keystore, String alias, char[] password) {
        try {
            Key key=keystore.getKey(alias,password);
            if(key instanceof PrivateKey) {
                Certificate cert=keystore.getCertificate(alias);
                PublicKey publicKey=cert.getPublicKey();
                return new KeyPair(publicKey,(PrivateKey)key);
            }
        } catch (UnrecoverableKeyException e) {
        } catch (NoSuchAlgorithmException e) {
        } catch (KeyStoreException e) {
        }
        return null;
    }
    public String export() throws Exception{
        KeyStore keystore=KeyStore.getInstance(keyStoreType);
        BASE64Encoder encoder=new BASE64Encoder();
        keystore.load(keystoreFile,password);
        KeyPair keyPair=getPrivateKey(keystore,alias,password);
        PrivateKey privateKey=keyPair.getPrivate();
        String encoded=encoder.encode(privateKey.getEncoded());

        return encoded;
    }
    public static void main(String args[]) throws Exception{
        ExportPrivateKey export=new ExportPrivateKey();
        //export.keystoreFile=new File("/Users/Luke/Workspace/StringTest/src/com/lukejin/stringtest/keystore.jks");
        export.keyStoreType="JKS";
        export.password="changeit".toCharArray();
        export.alias="tom_server";
        //export.exportedFile=new File("luke");
        export.export();
    }
}
