package com.cm_crm.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cm_crm.bean.auth.UserContext;
import com.cm_crm.mapper.VisitRecordMapper;
import com.cm_crm.service.VisitRecordService;
import com.cm_crm.util.auth.UserUtils;
import com.cm_crm.xsnowflake.SnowFlakeFactory;
import com.github.pagehelper.PageHelper;
import data.visitRecord.VisitRecord;
import excel.ExportVisitRecord;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 
 * @return: 走访记录service
 * @Author: wml
 */
@Service
@Transactional
public class VisitRecordServiceImpl extends ServiceImpl<VisitRecordMapper, VisitRecord> implements VisitRecordService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
    * @description: 获取列表
    * @author: wangmenglong
    **/
    @Override
    public List<VisitRecord> list(int pageNum, int pageSize, VisitRecord visitRecord,String startTime,String endTime) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<VisitRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(StringUtils.isNotBlank(visitRecord.getBranchOfficeId()),VisitRecord::getBranchOfficeId,visitRecord.getBranchOfficeId())
                .eq(StringUtils.isNotBlank(visitRecord.getCooperateId()),VisitRecord::getCooperateId,visitRecord.getCooperateId())
                .eq(StringUtils.isNotBlank(visitRecord.getCooperateCode()),VisitRecord::getCooperateCode,visitRecord.getCooperateCode())
                .like(StringUtils.isNotBlank(visitRecord.getBusinessTitle()),VisitRecord::getBusinessTitle,visitRecord.getBusinessTitle())
                .eq(VisitRecord::getDel,false)
                .ge(startTime != null, VisitRecord::getCreateTime, startTime)
                .le(endTime != null, VisitRecord::getCreateTime, endTime)
                .orderByDesc(VisitRecord::getCreateTime);
        List<VisitRecord> visitRecordList = super.list(qw);

        //返回查询结果
        return visitRecordList;
    }

    @Override
    public List<VisitRecord> queryListAll(VisitRecord visitRecord,String startTime,String endTime) {
        UserContext userContext = UserUtils.getUserContext();

        //创建查询条件
        LambdaQueryWrapper<VisitRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(StringUtils.isNotBlank(visitRecord.getBranchOfficeId()),VisitRecord::getBranchOfficeId,visitRecord.getBranchOfficeId())
                .eq(StringUtils.isNotBlank(visitRecord.getCooperateId()),VisitRecord::getCooperateId,visitRecord.getCooperateId())
                .eq(StringUtils.isNotBlank(visitRecord.getCooperateCode()),VisitRecord::getCooperateCode,visitRecord.getCooperateCode())
                .like(StringUtils.isNotBlank(visitRecord.getBusinessTitle()),VisitRecord::getBusinessTitle,visitRecord.getBusinessTitle())
                .eq(VisitRecord::getDel,false)
                .ge(startTime != null, VisitRecord::getCreateTime, startTime)
                .le(endTime != null, VisitRecord::getCreateTime, endTime)
                .orderByDesc(VisitRecord::getCreateTime);
        //返回查询结果
        return super.list(qw);
    }


    /**
    * @description: 新增
    * @author: wangmenglong
    **/
    @Override
    public boolean create(VisitRecord visitRecord) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        visitRecord.setId(snowFlakeFactory.nextId());
        visitRecord.setBaseCode(baseCode);
        visitRecord.setUserId(userContext.getUserId());
        visitRecord.setUserName(userContext.getUsername());
        visitRecord.setDel(false);
        visitRecord.setCreateTime(DateUtil.now());

        return super.save(visitRecord);
    }

    /**
    * @description: 编辑
    * @author: wangmenglong
    **/
    @Override
    public boolean update(VisitRecord visitRecord) {
        visitRecord.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(visitRecord.getId())){
            return false;
        }

        return super.saveOrUpdate(visitRecord);
    }


    /**
    * @description: 删除
    * @author: wangmenglong
    **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<VisitRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(VisitRecord::getId,id)
                .set(VisitRecord::getDel,true)
                .set(VisitRecord::getDelTime, DateUtil.now());
        return super.update(qw);
    }

    /**
    * @author: wangmenglong
    * @description: 获取详情
    **/
    @Override
    public VisitRecord getDetails(String id) {
        return super.getById(id);
    }


    @Override
    public void export(HttpServletResponse response, VisitRecord visitRecord,String startTime,String endTime){

        UserContext userContext = UserUtils.getUserContext();

        List<VisitRecord> list = queryListAll(visitRecord,startTime,endTime);

        List<ExportVisitRecord> exportVisitRecordList = new ArrayList<>();

        for (VisitRecord export:list) {

            ExportVisitRecord exportVisitRecord = new ExportVisitRecord();

            BeanUtils.copyProperties(export, exportVisitRecord,"photoUrl");

            if(export.getInteract()!=null||export.getInteract()){
                exportVisitRecord.setInteract("是");
            }else {
                exportVisitRecord.setInteract("否");
            }

            try {
                exportVisitRecord.setPhotoUrl(new URL(export.getPhotoUrl()));
            }catch (Exception e){
                e.printStackTrace();
            }

            exportVisitRecordList.add(exportVisitRecord);

        }

        try {
//            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String now = DateFormatUtils.format(new Date(), "yyyyMMddHHmmss");
            String fileName = URLEncoder.encode("走访记录" + now, "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-Type","application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ServletOutputStream outputStream = response.getOutputStream();
            EasyExcel.write(outputStream).sheet(0, "走访记录").head(ExportVisitRecord.class).doWrite(exportVisitRecordList);
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
