package com.cm_crm.service.impl;

import base.result.BaseResult;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cm_crm.bean.auth.UserContext;
import com.cm_crm.mapper.CooperateMapper;
import com.cm_crm.service.CooperateService;
import com.cm_crm.service.CountyDistrictService;
import com.cm_crm.util.auth.UserUtils;
import com.cm_crm.xsnowflake.SnowFlakeFactory;
import com.github.pagehelper.PageHelper;
import data.system.Cooperate;
import data.system.CountyDistrict;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import util.CommonUtils;
import util.MultipartFileToFile;
import util.excel.ExcelXlsxReader;

import java.io.File;
import java.util.*;

/**
 * 
 * @return: 合作伙伴service
 * @Author: wml
 */
@Service
@Transactional
public class CooperateServiceImpl extends ServiceImpl<CooperateMapper, Cooperate> implements CooperateService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    @Autowired
    CountyDistrictService countyDistrictService;

    /**
    * @description: 获取列表
    * @author: wangmenglong
    **/
    @Override
    public List<Cooperate> list(int pageNum, int pageSize, Cooperate cooperate) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Cooperate> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(cooperate.getName()),Cooperate::getName,cooperate.getName())
                .eq(StringUtils.isNotBlank(cooperate.getCode()),Cooperate::getCode,cooperate.getCode())
                .eq(Cooperate::getDel,false)
                .orderByDesc(Cooperate::getCreateTime);
        List<Cooperate> cooperateList = super.list(qw);

        //返回查询结果
        return cooperateList;
    }

    @Override
    public List<Cooperate> queryListAll() {
        UserContext userContext = UserUtils.getUserContext();

        //创建查询条件
        LambdaQueryWrapper<Cooperate> qw = new LambdaQueryWrapper<>();
        qw.eq(Cooperate::getDel,false)
                .eq(Cooperate::getBaseCode, userContext.getBaseCode())
                .orderByDesc(Cooperate::getCreateTime);
        List<Cooperate> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }

    /**
    * @description: 新增
    * @author: wangmenglong
    **/
    @Override
    public boolean create(Cooperate cooperate) {
        //校验用户名是否存在
        Cooperate u = super.getOne(new LambdaQueryWrapper<Cooperate>().eq(Cooperate::getDel, false )
                .eq(Cooperate::getName, cooperate.getName()));
        if(ObjectUtil.isNotNull(u)){
            return false;
        }

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        cooperate.setId(snowFlakeFactory.nextId());
        cooperate.setBaseCode(baseCode);
        cooperate.setUserId(userContext.getUserId());
        cooperate.setUserName(userContext.getUsername());
        cooperate.setDel(false);
        cooperate.setCreateTime(DateUtil.now());

        return super.save(cooperate);
    }

    /**
    * @description: 编辑
    * @author: wangmenglong
    **/
    @Override
    public boolean update(Cooperate cooperate) {
        cooperate.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(cooperate.getId())){
            return false;
        }

        return super.saveOrUpdate(cooperate);
    }


    /**
    * @description: 删除
    * @author: wangmenglong
    **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Cooperate> qw = new LambdaUpdateWrapper<>();
        qw.eq(Cooperate::getId,id)
                .set(Cooperate::getDel,true)
                .set(Cooperate::getDelTime, DateUtil.now());
        return super.update(qw);
    }


    /**
    * @author: wangmenglong
    * @description: 判断是否存在
    **/
    @Override
    public boolean isHave(String name, String id) {
        LambdaQueryWrapper<Cooperate> qw = new LambdaQueryWrapper<>();
        qw.eq(Cooperate::getDel,false)
                .eq(Cooperate::getName, name);
        if(StringUtils.isNotBlank(id)){
            qw.ne(Cooperate::getId,id);
        }
        return super.count(qw)>0;
    }

    /**
     * @author: wangmenglong
     * @description: 判断是否存在
     **/
    @Override
    public boolean isHaveCode(String code, String id) {
        LambdaQueryWrapper<Cooperate> qw = new LambdaQueryWrapper<>();
        qw.eq(Cooperate::getDel,false)
                .eq(Cooperate::getCode, code);
        if(StringUtils.isNotBlank(id)){
            qw.ne(Cooperate::getId,id);
        }
        return super.count(qw)>0;
    }



    /**
    * @author: wangmenglong
    * @description: 获取详情
    **/
    @Override
    public Cooperate getDetails(String id) {
        return super.getById(id);
    }


    @Override
    public BaseResult importCooperate(MultipartFile multipartFile) {

        try {

            UserContext userContext = UserUtils.getUserContext();
            String baseCode = userContext.getBaseCode();

            File file = MultipartFileToFile.multipartFileToFile(multipartFile);
            ExcelXlsxReader excelXlsxReader = new ExcelXlsxReader();
            Map<String, List<List<String>>> map = excelXlsxReader.process(file);
            List<List<String>> rowList = map.get("1");

            //上传的文件没有数据，请重新上传
            if (rowList.size() == 0 || rowList.size() == 1) {
                return BaseResult.error("error_007");
            }
            rowList.remove(0);

            List<CountyDistrict> countyDistrictList = countyDistrictService.listAll();

            List<Cooperate> cooperateList = new ArrayList<>();

            //此次导入的编号集合
            Set<String> nameSet = new HashSet<>();
            Set<String> codeSet = new HashSet<>();
            int rowNum = 1;
            // 校验导入数据
            for (List<String> colList : rowList) {

                Cooperate cooperate = new Cooperate();

                String name =  CommonUtils.replaceBlank(colList.get(0));
                String code =  CommonUtils.replaceBlank(colList.get(1));
                String countyDistrictInsert =  CommonUtils.replaceBlank(colList.get(2));

                if(nameSet.contains(name)||isHave(name,null)){
                    return BaseResult.error("error_009","第"+rowNum+"行有错误数据,名称重复：["+name+"]");
                }

                if(codeSet.contains(code)||isHaveCode(name,null)){
                    return BaseResult.error("error_009","第"+rowNum+"行有错误数据,编号重复：["+code+"]");
                }

                if(StringUtils.isBlank(name)||StringUtils.isBlank(code)||StringUtils.isBlank(countyDistrictInsert)){
                    return BaseResult.error("error_009","第"+rowNum+"行有错误数据,值为空值");
                }

                nameSet.add(name);
                codeSet.add(code);
                rowNum++;

                cooperate.setId(snowFlakeFactory.nextId());
                cooperate.setBaseCode(baseCode);
                cooperate.setUserId(userContext.getUserId());
                cooperate.setUserName(userContext.getUsername());
                cooperate.setDel(false);
                cooperate.setCreateTime(DateUtil.now());

                //excel导入的
                cooperate.setCode(code);
                cooperate.setName(name);
                cooperate.setCountyDistrict(countyDistrictInsert);

                for (CountyDistrict countyDistrict:countyDistrictList) {

                    if(countyDistrict.equals(countyDistrictInsert)) cooperate.setCountyDistrictId(countyDistrict.getId());

                }


                cooperateList.add(cooperate);
            }


            super.saveBatch(cooperateList);

            return BaseResult.success();
        }catch (Exception e){
            e.printStackTrace();
            return BaseResult.error("error_006");
        }

    }
}
