package com.cm_crm.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cm_crm.bean.auth.UserContext;
import com.cm_crm.mapper.BranchOfficeMapper;
import com.cm_crm.service.BranchOfficeService;
import com.cm_crm.util.auth.UserUtils;
import com.cm_crm.xsnowflake.SnowFlakeFactory;
import com.github.pagehelper.PageHelper;
import data.system.BranchOffice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 
 * @return: 分公司service
 * @Author: wml
 */
@Service
@Transactional
public class BranchOfficeServiceImpl extends ServiceImpl<BranchOfficeMapper, BranchOffice> implements BranchOfficeService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
    * @description: 获取列表
    * @author: wangmenglong
    **/
    @Override
    public List<BranchOffice> list(int pageNum, int pageSize, BranchOffice branchOffice) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<BranchOffice> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(branchOffice.getName()),BranchOffice::getName,branchOffice.getName())
                .eq(BranchOffice::getDel,false)
                .orderByDesc(BranchOffice::getCreateTime);
        List<BranchOffice> branchOfficeList = super.list(qw);

        //返回查询结果
        return branchOfficeList;
    }

    @Override
    public List<BranchOffice> queryListAll() {
        UserContext userContext = UserUtils.getUserContext();

        //创建查询条件
        LambdaQueryWrapper<BranchOffice> qw = new LambdaQueryWrapper<>();
        qw.eq(BranchOffice::getDel,false)
                .eq(BranchOffice::getBaseCode, userContext.getBaseCode())
                .orderByDesc(BranchOffice::getCreateTime);
        List<BranchOffice> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }

    /**
    * @description: 新增
    * @author: wangmenglong
    **/
    @Override
    public boolean create(BranchOffice branchOffice) {
        //校验用户名是否存在
        BranchOffice u = super.getOne(new LambdaQueryWrapper<BranchOffice>().eq(BranchOffice::getDel, false )
                .eq(BranchOffice::getName, branchOffice.getName()));
        if(ObjectUtil.isNotNull(u)){
            return false;
        }

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        branchOffice.setId(snowFlakeFactory.nextId());
        branchOffice.setBaseCode(baseCode);
        branchOffice.setUserId(userContext.getUserId());
        branchOffice.setUserName(userContext.getUsername());
        branchOffice.setDel(false);
        branchOffice.setCreateTime(DateUtil.now());

        return super.save(branchOffice);
    }

    /**
    * @description: 编辑
    * @author: wangmenglong
    **/
    @Override
    public boolean update(BranchOffice branchOffice) {
        branchOffice.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(branchOffice.getId())){
            return false;
        }

        return super.saveOrUpdate(branchOffice);
    }


    /**
    * @description: 删除
    * @author: wangmenglong
    **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<BranchOffice> qw = new LambdaUpdateWrapper<>();
        qw.eq(BranchOffice::getId,id)
                .set(BranchOffice::getDel,true)
                .set(BranchOffice::getDelTime, DateUtil.now());
        return super.update(qw);
    }


    /**
    * @author: wangmenglong
    * @description: 判断是否存在
    **/
    @Override
    public boolean isHave(String name, String id) {
        LambdaQueryWrapper<BranchOffice> qw = new LambdaQueryWrapper<>();
        qw.eq(BranchOffice::getDel,false)
                .eq(BranchOffice::getName, name);
        if(StringUtils.isNotBlank(id)){
            qw.ne(BranchOffice::getId,id);
        }
        return super.count(qw)>0;
    }



    /**
    * @author: wangmenglong
    * @description: 获取详情
    **/
    @Override
    public BranchOffice getDetails(String id) {
        return super.getById(id);
    }


}
