package com.cm_crm.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.cm_crm.service.VisitRecordService;
import com.github.pagehelper.PageInfo;
import data.visitRecord.VisitRecord;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 *
 * @return: 走访记录
 * @Author: wml
 * @Date 2025/5/9 11:31
 */
@RestController
@RequestMapping("/visit_record")
public class VisitRecordController extends BaseController {

    @Resource
    VisitRecordService visitRecordService;

    /**
     * @description: 获取列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req, VisitRecord visitRecord){
        String startTime = req.getParameter("startTime");
        String endTime = req.getParameter("endTime");
        PageInit(req);
        List<VisitRecord> list = visitRecordService.list(pageNum,pageSize,visitRecord,startTime,endTime);
        PageInfo<VisitRecord> pageInfo = new PageInfo<VisitRecord>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * 获取全部
     * @return: base.result.BaseResult
     * @Author: wml
     */
    @GetMapping("/l/all")
    public BaseResult lAll(HttpServletRequest req, VisitRecord visitRecord){
        String startTime = req.getParameter("startTime");
        String endTime = req.getParameter("endTime");
        List<VisitRecord> list = visitRecordService.queryListAll(visitRecord,startTime,endTime);
        return BaseResult.success("normal_001",list);
    }

    /**
     * @description: 新增
     * @author: wangmenglong
     **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody VisitRecord visitRecord){
        return visitRecordService.create(visitRecord)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑
     * @author: wangmenglong
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody VisitRecord visitRecord){
        return visitRecordService.update(visitRecord)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除
     * @author: wangmenglong
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return visitRecordService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
     * @author: wangmenglong
     **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        VisitRecord visitRecord = visitRecordService.getDetails(id);
        return BaseResult.success(visitRecord);
    }

    /**
     * 导出
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2023/12/13 16:05
     */
    @GetMapping("/export")
    public void personImportDown(HttpServletRequest req, HttpServletResponse response, VisitRecord visitRecord){
        String startTime = req.getParameter("startTime");
        String endTime = req.getParameter("endTime");
        visitRecordService.export(response,visitRecord,startTime,endTime);
    }

}
