package com.cm_crm.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.cm_crm.service.CountyDistrictService;
import com.cm_crm.service.UserService;
import com.github.pagehelper.PageInfo;
import data.system.CountyDistrict;
import data.user.User;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 *
 * @return: 县区管理
 * @Author: wml
 * @Date 2025/5/9 11:31
 */
@RestController
@RequestMapping("/county_district")
public class CountyDistrictController extends BaseController {

    @Resource
    CountyDistrictService countyDistrictService;

    /**
     * 获取区县
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2025/5/9 11:31
     */
    @GetMapping("/lall")
    public BaseResult listAll(HttpServletRequest req){
        List<CountyDistrict> list = countyDistrictService.listAll();
        return BaseResult.success(list);
    }

}
