package com.cm_crm.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.cm_crm.service.CooperateService;
import com.github.pagehelper.PageInfo;
import data.system.Cooperate;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 *
 * @return: 合作伙伴
 * @Author: wml
 * @Date 2025/5/9 11:31
 */
@RestController
@RequestMapping("/cooperate")
public class CooperateController extends BaseController {

    @Resource
    CooperateService cooperateService;

    /**
     * @description: 获取列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req, Cooperate cooperate){
        PageInit(req);
        List<Cooperate> list = cooperateService.list(pageNum,pageSize,cooperate);
        PageInfo<Cooperate> pageInfo = new PageInfo<Cooperate>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * 获取全部
     * @return: base.result.BaseResult
     * @Author: wml
     */
    @GetMapping("/l/all")
    public BaseResult lAll(HttpServletRequest req){
        List<Cooperate> list = cooperateService.queryListAll();
        return BaseResult.success("normal_001",list);
    }

    /**
     * @description: 新增
     * @author: wangmenglong
     **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Cooperate cooperate){
        //判断是否重复
        if(cooperateService.isHave(cooperate.getName(),cooperate.getId())){
            return BaseResult.error("error_005");
        }
        //判断是否重复
        if(cooperateService.isHaveCode(cooperate.getCode(),cooperate.getId())){
            return BaseResult.error("error_008");
        }
        return cooperateService.create(cooperate)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑
     * @author: wangmenglong
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Cooperate cooperate){
        //判断重复
        if(cooperateService.isHave(cooperate.getName(),cooperate.getId())){
            return BaseResult.error("error_005");
        }
        //判断是否重复
        if(cooperateService.isHaveCode(cooperate.getCode(),cooperate.getId())){
            return BaseResult.error("error_008");
        }
        return cooperateService.update(cooperate)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除
     * @author: wangmenglong
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return cooperateService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
     * @author: wangmenglong
     **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        Cooperate cooperate = cooperateService.getDetails(id);
        return BaseResult.success(cooperate);
    }

    /**
     * 合同名单查询导出
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2024/8/27 15:59
     */
    @PostMapping("/import")
    public BaseResult importCooperate(@RequestParam("file") MultipartFile multipartFile){
        BaseResult baseResult = cooperateService.importCooperate(multipartFile);
        return baseResult;
    }

}
