package com.cm_crm.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.cm_crm.service.BranchOfficeService;
import com.cm_crm.service.CountyDistrictService;
import com.github.pagehelper.PageInfo;
import data.system.BranchOffice;
import data.system.CountyDistrict;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 *
 * @return: 分公司
 * @Author: wml
 * @Date 2025/5/9 11:31
 */
@RestController
@RequestMapping("/branch_office")
public class BranchOfficeController extends BaseController {

    @Resource
    BranchOfficeService branchOfficeService;

    /**
     * @description: 获取列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req, BranchOffice branchOffice){
        PageInit(req);
        List<BranchOffice> list = branchOfficeService.list(pageNum,pageSize,branchOffice);
        PageInfo<BranchOffice> pageInfo = new PageInfo<BranchOffice>(list);
        return BaseResult.success(pageInfo);
    }

    /**
     * 获取全部
     * @return: base.result.BaseResult
     * @Author: wml
     */
    @GetMapping("/l/all")
    public BaseResult lAll(HttpServletRequest req){
        List<BranchOffice> list = branchOfficeService.queryListAll();
        return BaseResult.success("normal_001",list);
    }

    /**
     * @description: 新增
     * @author: wangmenglong
     **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody BranchOffice branchOffice){
        //判断是否重复
        if(branchOfficeService.isHave(branchOffice.getName(),branchOffice.getId())){
            return BaseResult.error("error_004");
        }
        return branchOfficeService.create(branchOffice)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑
     * @author: wangmenglong
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody BranchOffice branchOffice){
        //判断重复
        if(branchOfficeService.isHave(branchOffice.getName(),branchOffice.getId())){
            return BaseResult.error("error_004");
        }
        return branchOfficeService.update(branchOffice)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除
     * @author: wangmenglong
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return branchOfficeService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }


    /**
     * @author: wangmenglong
     **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        BranchOffice branchOffice = branchOfficeService.getDetails(id);
        return BaseResult.success(branchOffice);
    }

}
