package com.cm_crm.bean.auth;

import lombok.Data;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.Collection;

/**
 * @Author wangmenglong
 * @Description 用户登录用
 * @Date 15:33 2021/7/2
 * @Param
 * @return
 **/
@Data
public class SelfUserEntity implements UserDetails {
    /**
     * 用户ID
     */
    private String userId;
    /**
     * 用户名
     */
    private String username;
    /**
     * 密码
     */
    private String password;

    /**
     * 派遣公司编号
     */
    private String baseCode;
    /**
     * 状态:NORMAL正常  PROHIBIT禁用
     */
    private String status;

    /**
     * 名称
     */
    private String name;

    private String grayLabel;

    /**
     * 用户角色
     */
    private Collection<GrantedAuthority> authorities;
    /**
     * 账户是否过期
     */
    private boolean isAccountNonExpired = false;
    /**
     * 账户是否被锁定
     */
    private boolean isAccountNonLocked = false;
    /**
     * 证书是否过期
     */
    private boolean isCredentialsNonExpired = false;
    /**
     * 账户是否有效
     */
    private boolean isEnabled = true;

    /**
     * 账户类型，manage-管理端  person-员工端
     */
    private String type;

    /**
     * 雇员证件号码
     */
    private String idNo;

    /**
     * 角色id
     */
    private String roleId;

    /**
     * 角色标签
     */
    private String roleTag;

    /**
     * 微信openid
     */
    private String openId;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 是否超级管理员
     */
    private Boolean superAdmin;
    
}
