package excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.*;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.poi.ss.usermodel.FillPatternType;

import java.net.URL;
import java.util.Date;

/**
 * @author zhangsufang
 * @description: 简历导出
 * @date 2023/12/22 10:25
 */
@Data
@HeadRowHeight(20)
@HeadStyle(fillPatternType = FillPatternType.SOLID_FOREGROUND, fillForegroundColor = 22)
@HeadFontStyle(fontHeightInPoints = 11)
@ContentStyle(wrapped = true)
@ColumnWidth(20)
@TableName(value = "tb_visit_record")
//设置行高，其他导出不需要可以删掉
@ContentRowHeight(100)
public class ExportVisitRecord {

    @ExcelProperty("分公司")
    @TableField("branch_office")
    private String branchOffice;

    @ExcelProperty("合作伙伴编号")
    @TableField("cooperate_code")
    private String cooperateCode;

    @ExcelProperty("合作伙伴")
    @TableField("cooperate")
    private String cooperate;

    @ExcelProperty("是否合作过")
    private String interact;

    @ExcelProperty("商机名称")
    private String businessTitle;

    @ExcelProperty("金额")
    private Integer money;

    @ExcelProperty("创建时间")
    private String createTime;

    @ExcelProperty("建设内容")
    private String businessContent;

    @ExcelProperty(value = "走访图片")
    private URL photoUrl;

    @ExcelProperty("预计签约时间")
    private String signDate;

}
