package data.visitRecord;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import data.parent.IdentityObj;
import data.parent.NameObj;
import lombok.Data;

/**
 * @author wangmenglong
 * @description: 走访记录
 * @date 2025/5/9 10:50
 */
@Data
@TableName(value = "tb_visit_record")
public class VisitRecord extends IdentityObj {

    /**
     * 分公司id
     **/
    @TableField("branch_office_id")
    private String branchOfficeId;

    /**
     * 分公司
     **/
    @TableField("branch_office")
    private String branchOffice;

    /**
     * 合作伙伴id
     **/
    @TableField("cooperate_id")
    private String cooperateId;

    /**
     * 合作伙伴
     **/
    @TableField("cooperate")
    private String cooperate;

    /**
     * 合作伙伴code
     **/
    @TableField("cooperate_code")
    private String cooperateCode;

    /**
     * 是否合作过
     **/
    @TableField("interact")
    private Boolean interact;


    /**
     * 商机名称
     **/
    @TableField("business_title")
    private String businessTitle;

    @TableField("money")
    private Integer money;

    /**
     * 建设内容
     **/
    @TableField("business_content")
    private String businessContent;

    /**
     * 预计签约时间
     **/
    @TableField("sign_date")
    private String signDate;

    /**
     * 走访照片
     **/
    @TableField("photo_url")
    private String photoUrl;
}
