package com.jfb.recruit.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.IndustryService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Industry;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 行业管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/industry")
public class ApiIndustryController extends BaseController {

    @Resource
    IndustryService industryService;

    /**
     * @description: 获取行业列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l/all")
    public BaseResult listAll(HttpServletRequest req,Industry industry){
        List<Industry> list = industryService.listAll(industry);
        return BaseResult.success(list);
    }

}
