package util;

import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.springframework.core.io.ClassPathResource;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.*;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;


/**
 * @author wangmenglong
 * @description: RSA加解密
 * @date 2024/3/11 17:01
 */
public class RSAUtil {

    private static final String ALGORITHM = "RSA";

    public static void main(String [] args) throws Exception {
//        KeyPair keyPair = generateRsaKey(2048);
//        genPublicFile(keyPair);

        String encryptData = encrypt("下班",getPublicKey());
        System.out.println("加密后结果为："+ encryptData );
//
        String decryptData = decrypt(encryptData,getPrivateKey());
        System.out.println("解密后结果为："+ decryptData);
    }

    /**
     * RSA私钥解密
     * @param str  解密字符串
     * @param privateKey  私钥
     * @return 明文
     */
    public static String decrypt(String str, String privateKey) {
        //64位解码加密后的字符串
        byte[] inputByte;
        String outStr = "";
        try {
            inputByte = Base64.decodeBase64(str.getBytes("UTF-8"));
            //base64编码的私钥
            byte[] decoded = Base64.decodeBase64(privateKey);

            java.security.Security.addProvider(
                    new org.bouncycastle.jce.provider.BouncyCastleProvider()
            );

            RSAPrivateKey priKey = (RSAPrivateKey) KeyFactory.getInstance(ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(decoded));
            //RSA解密
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, priKey);
            outStr = new String(cipher.doFinal(inputByte));
        } catch (UnsupportedEncodingException | NoSuchPaddingException | InvalidKeyException |
                 IllegalBlockSizeException | BadPaddingException | InvalidKeySpecException |
                 NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return outStr;
    }

    /**
     *  RSA公钥加密
     * @param str 需要加密的字符串
     * @param publicKey 公钥
     * @return 密文
     * @throws Exception 加密过程中的异常信息
     */
    public static String encrypt(String str, String publicKey) throws Exception {
        //base64编码的公钥
        byte[] decoded = Base64.decodeBase64(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey) KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(decoded));
        //RSA加密
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(Cipher.ENCRYPT_MODE, pubKey);
        String outStr = Base64.encodeBase64String(cipher.doFinal(str.getBytes("UTF-8")));
        return outStr;
    }


    public static String getPrivateKey() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource("private_key.jks");
        InputStream inputStream =classPathResource.getInputStream();
        byte[] privateKeyByte = new byte[inputStream.available()];
        inputStream.read(privateKeyByte);
        String privateKeyAll = new String(privateKeyByte);
        String privateKey = privateKeyAll.replace("-----BEGIN RSA PRIVATE KEY-----","").replace("-----END RSA PRIVATE KEY-----","");
//        System.out.println("私钥为："+privateKey);
        return privateKey;
    }

    public static String getPublicKey() throws IOException {
        ClassPathResource classPathResource = new ClassPathResource("public_key.jks");
        InputStream inputStream =classPathResource.getInputStream();
        byte[] publicKeyByte = new byte[inputStream.available()];
        inputStream.read(publicKeyByte);
        String publicKeyAll = new String(publicKeyByte);
        String publicKey = publicKeyAll.replace("-----BEGIN PUBLIC KEY-----","").replace("-----END PUBLIC KEY-----","");
//        System.out.println("公钥为："+publicKey);
        return publicKey;
    }


    /**
     * 生成RSA 公私钥,可选长度为1025,2048位.
     */
    public static KeyPair generateRsaKey(int keySize) {
        Map<String,String> result = new HashMap<>(2);
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(ALGORITHM);

            // 初始化密钥对生成器，密钥大小为1024 2048位
            keyPairGen.initialize(keySize, new SecureRandom());

            // 生成一个密钥对，保存在keyPair中
            KeyPair keyPair = keyPairGen.generateKeyPair();

            return keyPair;

            // 得到公钥字符串
//            result.put("publicKey", new String(Base64.encodeBase64(keyPair.getPublic().getEncoded())));
//            // 得到私钥字符串
//            result.put("privateKey", new String(Base64.encodeBase64(keyPair.getPrivate().getEncoded())));
        } catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 生成公钥文件
     * @param keyPair 密钥对
     * @return 公钥/私钥文件
     */
    public static File genPublicFile(KeyPair keyPair) {
        try (StringWriter sw = new StringWriter()) {
            // 得到公钥
            PublicKey publicKey = keyPair.getPublic();
            // 得到私钥
            PrivateKey privateKey = keyPair.getPrivate();
            // 获取PublicKey并将其转换为PEM格式的字符串
            try (JcaPEMWriter pemWriter = new JcaPEMWriter(sw)) {
                pemWriter.writeObject(publicKey);
                pemWriter.writeObject(privateKey);
            } catch (IOException e) {
                throw new RuntimeException(e);
            }

            File file = new File("E:\\rsa.jks");

            try (FileWriter fw = new FileWriter(file.getAbsoluteFile(), true);
                 BufferedWriter bw = new BufferedWriter(fw)
            ) {
                bw.write(sw.toString());
            } catch (IOException e) {
                throw new RuntimeException(e);
            }

            return file;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


}

