package com.jfb.recruit.service.impl;

import base.result.BaseResult;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.RecruitMapper;
import com.jfb.recruit.service.RecruitService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Recruit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;

import java.util.List;

/**
 *
 * @return: 招聘管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class RecruitServiceImpl extends ServiceImpl<RecruitMapper, Recruit> implements RecruitService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取招聘列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.recruit.Recruit>
     **/
    @Override
    public List<Recruit> list(int pageNum, int pageSize, Recruit recruit) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Recruit> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(recruit.getName()),Recruit::getName,recruit.getName())
                .eq(StringUtils.isNotBlank(recruit.getRecruitTypeId()),Recruit::getRecruitTypeId,recruit.getRecruitTypeId())
                .eq(Recruit::getDel,false)
                .eq(StringUtils.isNotBlank(recruit.getBaseCode()),Recruit::getBaseCode, recruit.getBaseCode())
                .orderByDesc(Recruit::getCreateTime);
        List<Recruit> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }


    /**
     * @description: 新增招聘
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [recruit]
     * @return: boolean
     **/
    @Override
    public boolean create(Recruit recruit) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        recruit.setId(snowFlakeFactory.nextId());
        recruit.setBaseCode(baseCode);
        recruit.setDel(false);
        recruit.setCreateTime(DateUtil.now());

        return super.save(recruit);
    }

    /**
     * @description: 编辑招聘
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [org]
     * @return: boolean
     **/
    @Override
    public boolean update(Recruit recruit) {
        recruit.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(recruit.getId())){
            return false;
        }
        return super.saveOrUpdate(recruit);
    }

    /**
     * @description: 删除招聘
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Recruit> qw = new LambdaUpdateWrapper<>();
        qw.eq(Recruit::getId,id)
                .set(Recruit::getDel,true)
                .set(Recruit::getDelTime, DateUtil.now());

        Recruit recruit = super.getById(id);

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取招聘详情
     * @param: [id]
     * @return: data.recruit.Recruit
     **/
    @Override
    public Recruit getDetails(String id) {
        return super.getById(id);
    }

}
