package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.PersonMapper;
import com.jfb.recruit.service.PersonService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Person;
import data.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 报名员工管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class PersonServiceImpl extends ServiceImpl<PersonMapper, Person> implements PersonService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取报名员工列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.person.Person>
     **/
    @Override
    public List<Person> list(int pageNum, int pageSize, Person person) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<Person> qw = new LambdaQueryWrapper<>();
        qw.like(StringUtils.isNotBlank(person.getName()),Person::getName,person.getName())
                .eq(Person::getDel,false)
                .eq(StringUtils.isNotBlank(person.getBaseCode()),Person::getBaseCode, person.getBaseCode())
                .eq(StringUtils.isNotBlank(person.getRecruitTypeId()),Person::getRecruitTypeId, person.getRecruitTypeId())
                .like(StringUtils.isNotBlank(person.getRecruitType()),Person::getRecruitType, person.getRecruitType())
                .orderByDesc(Person::getCreateTime);
        List<Person> personList = super.list(qw);
        //返回查询结果
        return personList;
    }


    /**
     * @description: 新增报名员工
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [person]
     * @return: boolean
     **/
    @Override
    public boolean create(Person person) {

        //UserContext userContext = UserUtils.getUserContext();
        //String baseCode = userContext.getBaseCode();

        person.setId(snowFlakeFactory.nextId());
        person.setBaseCode("jyjfb");
        person.setDel(false);
        person.setCreateTime(DateUtil.now());

        return super.save(person);
    }

    /**
     * @description: 编辑报名员工
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [person]
     * @return: boolean
     **/
    @Override
    public boolean update(Person person) {
        person.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(person.getId())){
            return false;
        }
        return super.saveOrUpdate(person);
    }

    /**
     * @description: 删除报名员工
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<Person> qw = new LambdaUpdateWrapper<>();
        qw.eq(Person::getId,id)
                .set(Person::getDel,true)
                .set(Person::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取报名员工详情
     * @param: [id]
     * @return: data.person.Person
     **/
    @Override
    public Person getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String openId, String id) {
        LambdaQueryWrapper<Person> qw = new LambdaQueryWrapper<>();
        qw.eq(Person::getDel,false)
                .eq(Person::getOpenId, openId);
        //如果传了id就是编辑，编辑的时候要加个条件，不能把名字跟别人重复
        if(StringUtils.isNotBlank(id)){
            qw.ne(Person::getId,id);
        }
        return super.count(qw)>0;
    }

    /**
     * @author: wangmenglong
     * @date; 2025/5/9 10:22
     * @description: 获取用户详情,登陆用
     * @param: [id]
     * @return: data.user.User
     **/
    @Override
    public Person getDetailsByLoginOpenId(String openId) {

        //创建查询条件
        LambdaQueryWrapper<Person> qw = new LambdaQueryWrapper<>();
        qw.eq(Person::getOpenId,openId)
                .eq(Person::getDel,false);

        return super.getOne(qw);
    }
}
