package com.jfb.recruit.service.auth;


import com.jfb.recruit.bean.auth.SelfUserEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Component
public class UserAuthenticationProvider implements AuthenticationProvider {
    @Autowired
    private SelfUserDetailsService selfUserDetailsService;
    private static final String SALT = "junying";

    @Override
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        HttpServletRequest req = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String wxType = req.getParameter("wxType");
        SelfUserEntity sysUserEntity = new SelfUserEntity();

        // 获取表单输入中返回的用户名
//        String username = (String) authentication.getPrincipal();
        String username = authentication.getName();
        // 获取表单中输入的密码
        String password = DigestUtils.md5DigestAsHex(authentication.getCredentials().toString().getBytes());

        // 查询用户是否存在
        SelfUserEntity userInfo = selfUserDetailsService.loadUserByUsername(username);

        if(org.apache.commons.lang3.StringUtils.isNotBlank(wxType)&&wxType.equals("wx")){

        }else{
            //验证密码是否正确
            if (!userInfo.getPassword().equals(password)) {
                throw new BadCredentialsException("密码不正确");
            }
        }

        return new UsernamePasswordAuthenticationToken(userInfo, password, userInfo.getAuthorities());
    }

    @Override
    public boolean supports(Class<?> authentication) {
        return true;
    }


    /**
     * 字符换MD5
     * @param password
     * @return
     */
    public static String strToMd5(String password) {
        if(org.springframework.util.StringUtils.isEmpty(password)){
            return password;
        }
        password = SALT + password + SALT;
        String  md5Prd =  DigestUtils.md5DigestAsHex(password.getBytes());
        return md5Prd;
    }
}
