package com.jfb.recruit.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.OrgService;
import com.jfb.recruit.service.RecruitService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Org;
import data.recruit.Recruit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import static sun.font.CreatedFontTracker.MAX_FILE_SIZE;

/**
 * @author wangmenglong
 * @description: 招聘管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/import/recruit")
public class ImportRecruitController extends BaseController {

    @Resource
    RecruitService recruitService;

    @Resource
    OrgService orgService;

    /**
     * 获取企业信息
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @PostMapping(value = "/upload/51job/org/url/json", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public BaseResult uploadJsonOrgUrlFile(HttpServletRequest req,@RequestParam("file") MultipartFile file) {

        // 1. 校验文件是否为空
        if (file.isEmpty()) {
            return BaseResult.error("001");
        }

        // 2. 校验文件类型（增强严谨性，避免OOXML错误）
        String originalFilename = file.getOriginalFilename();
        // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
        if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
            return BaseResult.error("002");
        }
        // 可选：额外校验Content-Type，进一步防止非JSON文件
        String contentType = file.getContentType();
        if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                && !contentType.equalsIgnoreCase("text/plain")) {
            return BaseResult.error("002");
        }

        // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
        StringBuilder jsonContent = new StringBuilder();
        // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
        )) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }

            List<String> list = new ArrayList<>();

            JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());

            for (int i = 0; i < jsonArray.size(); i++) {

                JSONObject jsonObject = jsonArray.getJSONObject(i);

                list.add(jsonObject.getString("companyHref"));

            }

            // 4. 返回成功响应
            return BaseResult.success(list); // 优化：确保返回字符串类型

        } catch (IOException e) {
            return BaseResult.error("003");
        }
    }

    /**
     * 保存信息
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @PostMapping(value = "/upload/51job/org/json", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public BaseResult uploadJsonOrgFile(HttpServletRequest req,@RequestParam("file") MultipartFile file) {

        String regionCode = req.getParameter("regionCode");
        String province = req.getParameter("province");
        String city = req.getParameter("city");
        String region = req.getParameter("region");

        // 1. 校验文件是否为空
        if (file.isEmpty()) {
            return BaseResult.error("001");
        }

        // 2. 校验文件类型（增强严谨性，避免OOXML错误）
        String originalFilename = file.getOriginalFilename();
        // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
        if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
            return BaseResult.error("002");
        }
        // 可选：额外校验Content-Type，进一步防止非JSON文件
        String contentType = file.getContentType();
        if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                && !contentType.equalsIgnoreCase("text/plain")) {
            return BaseResult.error("002");
        }

        // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
        StringBuilder jsonContent = new StringBuilder();
        // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
        )) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }

            JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());


            for (int i = 0; i < jsonArray.size(); i++) {

                JSONObject jsonObject = jsonArray.getJSONObject(i);

                Org orgDetails = orgService.getName(jsonObject.getString("fullCompanyName"));

                if (orgDetails == null) {

                    Org org = new Org();
                    org.setName(jsonObject.getString("name"));
                    org.setDescr(jsonObject.getString("intro"));
                    org.setAddress(jsonObject.getString("address"));
                    org.setRegionCode(regionCode);
                    org.setRegion(region);
                    org.setProvince(province);
                    org.setCity(city);
                    orgService.create(org);
                }

            }


            // 4. 返回成功响应
            return BaseResult.success(jsonArray); // 优化：确保返回字符串类型

        } catch (IOException e) {
            return BaseResult.error("003");
        }
    }

    /**
     * 保存信息
     * @return: base.result.BaseResult
     * @Author: wml
     * @Date 2026/1/12 15:33
     */
    @PostMapping(value = "/upload/51job/json", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    public BaseResult uploadJsonFile(HttpServletRequest req,@RequestParam("file") MultipartFile file) {

        String recruitTypeId = req.getParameter("recruitTypeId");
        String recruitType = req.getParameter("recruitType");
        String experienceId = req.getParameter("experienceId");
        String experience = req.getParameter("experience");
        String qualificationId = req.getParameter("qualificationId");
        String qualification = req.getParameter("qualification");
        String payTimes = req.getParameter("payTimes");
        String startDate = req.getParameter("startDate");
        String expiredDate = req.getParameter("expiredDate");
        String qualificationCode = req.getParameter("qualificationCode");
        String experienceCode = req.getParameter("experienceCode");
        String province = req.getParameter("province");
        String city = req.getParameter("city");
        String region = req.getParameter("region");
        String oneIndustryName = req.getParameter("oneIndustryName");
        String oneIndustryId = req.getParameter("oneIndustryId");
        String towIndustryName = req.getParameter("towIndustryName");
        String towIndustryId = req.getParameter("towIndustryId");
        String industryCode = req.getParameter("industryCode");

        // 1. 校验文件是否为空
        if (file.isEmpty()) {
            return BaseResult.error("001");
        }

        // 2. 校验文件类型（增强严谨性，避免OOXML错误）
        String originalFilename = file.getOriginalFilename();
        // 优化：双重校验（后缀+内容类型，防止改后缀的非JSON文件）
        if (originalFilename == null || !originalFilename.trim().toLowerCase().endsWith(".json")) {
            return BaseResult.error("002");
        }
        // 可选：额外校验Content-Type，进一步防止非JSON文件
        String contentType = file.getContentType();
        if (contentType != null && !contentType.equalsIgnoreCase("application/json")
                && !contentType.equalsIgnoreCase("text/plain")) {
            return BaseResult.error("002");
        }

        // 3. 读取文件全部内容（确保流仅用于文本读取，避免被Office解析库误处理）
        StringBuilder jsonContent = new StringBuilder();
        // 核心：仅用BufferedReader读取文本，不引入任何Office解析逻辑
        try (BufferedReader reader = new BufferedReader(
                new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8) // 强制UTF-8，避免乱码
        )) {
            String line;
            while ((line = reader.readLine()) != null) {
                jsonContent.append(line);
            }

            JSONArray jsonArray = JSONArray.parseArray(jsonContent.toString());


            for (int i = 0; i < jsonArray.size(); i++) {

                JSONObject jsonObject = jsonArray.getJSONObject(i);

                Org orgDetails = orgService.getName(jsonObject.getString("fullCompanyName"));

                if(orgDetails!=null&& StringUtils.isNotBlank(orgDetails.getId())){

                    Recruit recruit = new Recruit();
                    recruit.setRecruitType(recruitType);
                    recruit.setRecruitTypeId(recruitTypeId);
                    recruit.setExperience(experience);
                    recruit.setExperienceId(experienceId);
                    recruit.setQualification(qualification);
                    recruit.setQualificationId(qualificationId);
                    recruit.setPayTimes(Integer.parseInt(payTimes));
                    recruit.setStartDate(startDate);
                    recruit.setExpiredDate(expiredDate);
                    recruit.setQualificationCode(qualificationCode);
                    recruit.setExperienceCode(experienceCode);
                    recruit.setProvince(province);
                    recruit.setCity(city);
                    recruit.setRegion(region);
                    recruit.setOneIndustryName(oneIndustryName);
                    recruit.setOneIndustryId(oneIndustryId);
                    recruit.setTowIndustryName(towIndustryName);
                    recruit.setTowIndustryId(towIndustryId);
                    recruit.setIndustryCode(industryCode);
                    recruit.setName(jsonObject.getString("jobName"));
                    recruit.setDetails(jsonObject.getString("jobDescribe"));
                    recruit.setSalaryMax(jsonObject.getInteger("jobSalaryMax"));
                    recruit.setSalaryMin(jsonObject.getInteger("jobSalaryMin"));
                    recruit.setOrgId(orgDetails.getId());
                    recruit.setOrgName(orgDetails.getName());
                    recruitService.create(recruit);

                }
            }


            // 4. 返回成功响应
            return BaseResult.success(jsonArray); // 优化：确保返回字符串类型

        } catch (IOException e) {
            return BaseResult.error("003");
        }
    }

}
