package base.result;

import enums.ExceptionCodeEnum;

public class BaseResult {
    private Object data;
    private boolean isSuccess = false;
    private String status = "";
    private String message = "";
    private String code;

    public BaseResult() {
    }

    public static BaseResult success(String code, Object data) {
        BaseResult result = new BaseResult();
        result.data = data;
        result.code = code;
        result.isSuccess = true;
        result.status = "success";
        return result;
    }

    public static BaseResult success(String code) {
        BaseResult result = new BaseResult();
        result.code = code;
        result.isSuccess = true;
        result.status = "success";
        return result;
    }

    public static BaseResult success(Object data) {
        BaseResult result = new BaseResult();
        result.data = data;
        result.code = "normal_001";
        result.isSuccess = true;
        result.status = "success";
        return result;
    }

    public static BaseResult success() {
        BaseResult result = new BaseResult();
        result.code = "normal_001";
        result.isSuccess = true;
        result.status = "success";
        return result;
    }


    public static BaseResult error(String code) {
        BaseResult result = new BaseResult();
        result.code = code;
        result.isSuccess = false;
        result.status = "error";
        return result;
    }

    public static BaseResult error(String code,Object data) {
        BaseResult result = new BaseResult();
        result.code = code;
        result.isSuccess = false;
        result.status = "error";
        result.data = data;
        return result;
    }

    public static BaseResult error(ExceptionCodeEnum exceptionCodeEnum) {
        BaseResult result = new BaseResult();
        result.code = exceptionCodeEnum.getCode();
        result.message = exceptionCodeEnum.getMessage();
        result.isSuccess = false;
        result.status = "error";
        return result;
    }

    public Object getData() {
        return this.data;
    }

    public boolean getIsSuccess() {
        return this.isSuccess;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCode() {
        return this.code;
    }
}