package util;

import java.util.Collections;
import java.util.List;

/**
 * 分页类
 */
public class Paging {

    /**
     * 当前页码
     */
    private int page;
    /**
     * 页码总数
     */
    //private int total;
    /**
     * 数据行总数
     */
    private int total;
    /**
     * 数据
     */
    private List list;

    private String code;

    private Paging() {
    }

    public Paging(int count, List data) {
//        this.page = page;
        this.total = count;
        this.list = data;
        this.code = "0";
    }

    public static Paging error(String code) {
        Paging paging = new Paging();
        paging.setTotal(0);
        paging.setList(Collections.emptyList());
        paging.setCode(code);
        return paging;
    }


    /**
     * 当前页码
     *
     * @return the page
     */
    public int getPage() {
        return page;
    }

    /**
     * 当前页码
     *
     * @param page the page to set
     */
    public void setPage(int page) {
        this.page = page;
    }

    /**
     * 数据行总数
     *
     * @return the count
     */
    public int getTotal() {
        return total;
    }

    /**
     * 数据行总数
     *
     * @param total the count to set
     */
    public void setTotal(int total) {
        this.total = total;
    }

    /**
     * 数据
     *
     * @return the data
     */
    public List getList() {
        return list;
    }

    /**
     * 数据
     *
     * @param list the data to set
     */
    public void setList(List list) {
        this.list = list;
    }

    /**
     * @return the code
     */
    public String getCode() {
        return code;
    }

    /**
     * @param code the code to set
     */
    public void setCode(String code) {
        this.code = code;
    }
}
