package data.recruit;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import data.parent.NameObj;
import lombok.Data;

/**
 * @author wangmenglong
 * @description: 报名记录
 * @date 2023/12/11 10:50
 */
@Data
@TableName(value = "tb_recruit")
public class Recruit extends NameObj {

    /**
     * 职位描述
     **/
    @TableField("details")
    private String details;


    /**
     * 招聘类型
     **/
    @TableField("recruit_type_id")
    private String recruitTypeId;

    /**
     * 招聘类型
     **/
    @TableField("recruit_type")
    private String recruitType;


    /**
     * 经验要求
     **/
    @TableField("experience_id")
    private String experienceId;


    /**
     * 经验要求
     **/
    @TableField("experience")
    private String experience;

    /**
     * 学历要求
     **/
    @TableField("qualification_id")
    private String qualificationId;

    /**
     * 学历要求
     **/
    @TableField("qualification")
    private String qualification;

    /**
     * 薪资范围开始
     **/
    @TableField("salary_min")
    private Integer salaryMin;

    /**
     * 薪资范围结束
     **/
    @TableField("salary_max")
    private Integer salaryMax;

    /**
     * 发薪次数
     **/
    @TableField("pay_times")
    private Integer payTimes;

    /**
     * 关键词
     **/
    @TableField("tags")
    private String tags;

    /**
     * 奖金绩效
     **/
    @TableField("bonus")
    private String bonus;

    /**
     * 地址
     **/
    @TableField("address")
    private String address;

    /**
     * 支付宝行业id
     **/
    @TableField("industry_id")
    private String industryId;

    /**
     * 次数
     **/
    @TableField("times")
    private Integer times;

}
