package com.jfb.recruit.filter;

import com.alibaba.fastjson.JSONObject;
import com.jfb.recruit.bean.auth.SelfUserEntity;
import com.jfb.recruit.config.auth.JWTConfig;
import com.jfb.recruit.util.auth.ExportPrivateKey;
import com.jfb.recruit.util.auth.ResultUtil;
import com.jfb.recruit.service.UserService;
import com.jfb.recruit.util.auth.InjectUtil;
import data.user.User;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;


public class JWTAuthenticationTokenFilter extends BasicAuthenticationFilter {

    private UserService userService = InjectUtil.getInstance().getUserService();

    public JWTAuthenticationTokenFilter(AuthenticationManager authenticationManager) {
        super(authenticationManager);
    }

    @Override
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        StringBuffer requestURL = request.getRequestURL();
        String provider = "";
        try {
            ClassPathResource classPathResource = new ClassPathResource("cm-crm-jwt.jks");
            InputStream inputStream = classPathResource.getInputStream();

            ExportPrivateKey export = new ExportPrivateKey();
            export.keystoreFile = inputStream;
            export.keyStoreType = "JKS";
            export.password = JWTConfig.secret.toCharArray();
            export.alias = "cm-crm-jwt";
            //export.exportedFile=new File("luke");
            provider = export.export();
        } catch (Exception e) {
            System.out.println("Token无效");
            return;
        }

        // 获取请求头中JWT的Token
        String tokenHeader = request.getHeader(JWTConfig.tokenHeader);
        if (null != tokenHeader && tokenHeader.startsWith(JWTConfig.tokenPrefix)) {
            try {
                // 截取JWT前缀
                String token = tokenHeader.replace(JWTConfig.tokenPrefix, "");
                // 解析JWT
                Claims claims = Jwts.parser()
                        .setSigningKey(provider)
                        .parseClaimsJws(token)
                        .getBody();
                // 获取用户名
                String username = claims.getSubject();
                String userId = claims.getId();

                //查询当前账号的状态，如果是禁用直接返回
                //if("manage".equals(claims.get("type"))){

                    User user = userService.getDetailsByLoginAccount(username);

                    if (user == null) {
                        ResultUtil.responseJson(response,ResultUtil.resultCode(102,"账号不存在"));
                        throw new UsernameNotFoundException("账号不存在");
                    }
                    Object state = user.getState();
                    if (!Objects.equals(state, "normal")) {
                        ResultUtil.responseJson(response,ResultUtil.resultCode(101,"账号被禁用"));
                        // 账号被禁用
                        throw new LockedException("账号被禁用");
                    }
                //}

                if (!StringUtils.isEmpty(username) && !StringUtils.isEmpty(userId)) {
                    // 获取角色
                    List<GrantedAuthority> authorities = new ArrayList<>();

                    String baseCode = claims.get("baseCode").toString();

                    if (claims.get("authorities")!=null&&!StringUtils.isEmpty(claims.get("authorities").toString())&&!"null".equals(claims.get("authorities"))) {
                        String authority = claims.get("authorities").toString();
                        List<Map<String, String>> authorityMap = JSONObject.parseObject(authority, List.class);
                        for (Map<String, String> role : authorityMap) {
                            if (role != null) {
                                authorities.add(new SimpleGrantedAuthority(role.get("authority")));
                            }
                        }
                    }
                    //组装参数
                    SelfUserEntity selfUserEntity = new SelfUserEntity();
                    selfUserEntity.setUsername(claims.getSubject());
                    selfUserEntity.setUserId(claims.getId());
                    selfUserEntity.setAuthorities(authorities);
                    selfUserEntity.setBaseCode(baseCode);
                    selfUserEntity.setName(claims.getOrDefault("name", "").toString());
                    selfUserEntity.setType(claims.getOrDefault("type", "").toString());
                    selfUserEntity.setRoleId(claims.getOrDefault("roleId", "").toString());
                    selfUserEntity.setRoleTag(claims.getOrDefault("roleTag", "").toString());
                    selfUserEntity.setIdNo(claims.getOrDefault("idNo", "").toString());
                    selfUserEntity.setOpenId(claims.getOrDefault("openId","").toString());
                    selfUserEntity.setPhone(claims.getOrDefault("phone","").toString());
                    selfUserEntity.setSuperAdmin(Boolean.parseBoolean(claims.getOrDefault("superAdmin", "false").toString()));
                    UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken(selfUserEntity, userId, authorities);
                    SecurityContextHolder.getContext().setAuthentication(authentication);
                }
            } catch (ExpiredJwtException e) {
                System.out.println("Token过期");
            } catch (LockedException e){
                System.out.println("=============================账号被禁用======================");
            }catch (UsernameNotFoundException e){
                System.out.println("=============================账号不存在======================");
            }catch (Exception e) {
                //System.out.println("Token无效4");
            }
        }
        filterChain.doFilter(request, response);
        return;
    }
}