package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.CollectService;
import com.jfb.recruit.service.RecruitService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Collect;
import data.recruit.Recruit;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 收藏管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/collect")
public class CollectController extends BaseController {

    @Resource
    CollectService collectService;

    @Resource
    RecruitService recruitService;

    /**
     * @description: 获取收藏列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        List<Recruit> list = recruitService.listByCollect(pageNum,pageSize,userContext.getUserId());
        PageInfo<Recruit> pageInfo = new PageInfo<Recruit>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增收藏
    * @author: wangmenglong
    * @param: [collect]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Collect collect){

        UserContext userContext = UserUtils.getUserContext();
        collect.setUserId(userContext.getUserId());
        collect.setPersonId(userContext.getUserId());

        //判断是否重复
        if(collectService.isHave(collect.getRecruitId(),collect.getPersonId())){
            collectService.del(collect.getRecruitId(),collect.getPersonId());
        }else {
            collectService.create(collect);
        }
        return BaseResult.success("normal_001");
    }


}
