package com.jfb.recruit.util.auth;

import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

import javax.security.auth.x500.X500Principal;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.*;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Date;

/**
 * @author wangmenglong
 * @description: 生成jks文件
 * @date 2024/1/3 18:43
 */
public class JksGenerator {

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);

        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();

        X509Certificate cert = generateCertificate(keyPair);
        keyStore.setKeyEntry("cm-crm-jwt", keyPair.getPrivate(), "cm-crm@junying".toCharArray(), new Certificate[]{cert});
        FileOutputStream fos = new FileOutputStream("cm-crm-jwt.jks");
        keyStore.store(fos, "cm-crm@junying".toCharArray());
        fos.close();

    }

    private static X509Certificate generateCertificate(KeyPair keyPair) throws CertificateEncodingException, NoSuchAlgorithmException, SignatureException, NoSuchProviderException, InvalidKeyException {
        // 创建证书生成器
        X509V3CertificateGenerator certGenerator = new X509V3CertificateGenerator();

        // 设置证书的基本信息
        certGenerator.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        certGenerator.setSubjectDN(new X500Principal("CN=Test Certificate"));
        certGenerator.setIssuerDN(new X500Principal("CN=Test CA Certificate"));
        certGenerator.setNotBefore(new Date(System.currentTimeMillis() - 1000L * 60 * 60 * 24));
        certGenerator.setNotAfter(new Date(System.currentTimeMillis() + 1000L * 60 * 60 * 24 * 365));
        certGenerator.setPublicKey(keyPair.getPublic());
        certGenerator.setSignatureAlgorithm("SHA256WithRSAEncryption");

        // 生成证书
        return certGenerator.generate(keyPair.getPrivate(), "BC");

    }
}
