package com.jfb.recruit.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jfb.recruit.mapper.QualificationMapper;
import com.jfb.recruit.service.QualificationService;
import data.recruit.Qualification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 学历
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class QualificationServiceImpl extends ServiceImpl<QualificationMapper, Qualification> implements QualificationService {


    /**
     * @description: 获取所有列表
     * @author: wangmenglong
     **/
    @Override
    public List<Qualification> listAll(Qualification qualification) {
        //创建查询条件
        LambdaQueryWrapper<Qualification> qw = new LambdaQueryWrapper<>();
        qw.eq(Qualification::getDel,false)
                .eq(StringUtils.isNotBlank(qualification.getBaseCode()),Qualification::getBaseCode, qualification.getBaseCode())
                .orderByDesc(Qualification::getCreateTime);
        List<Qualification> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }

    /**
     * @description: 根据名字获取
     * @author: wangmenglong
     **/
    @Override
    public Qualification queryByName(String name) {
        //创建查询条件
        LambdaQueryWrapper<Qualification> qw = new LambdaQueryWrapper<>();
        qw.eq(Qualification::getDel,false)
                .eq(Qualification::getName, name);
        //返回查询结果
        return super.getOne(qw);
    }

}
