package com.jfb.recruit.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.PersonService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.Person;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 人员管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/person")
public class ApiPersonController extends BaseController {

    @Resource
    PersonService personService;

    /**
    * @description: 新增人员
    * @author: wangmenglong
    * @param: [person]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody Person person){
        //判断是否重复
        if(personService.isHave(person.getOpenId(),person.getId())){
            return BaseResult.success("normal_001");
        }
        return personService.create(person)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑人员
     * @author: wangmenglong
     * @param: [person]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody Person person){
        //判断是否重复
        if(personService.isHave(person.getOpenId(),person.getId())){
            return BaseResult.success("normal_001");
        }
        return personService.update(person)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }



}
