package data.recruit;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import data.parent.IdentityObj;
import data.parent.NameObj;
import lombok.Data;

/**
 * @author wangmenglong
 * @description: 求职意向
 * @date 2023/12/11 10:50
 */
@Data
@TableName(value = "tb_objective")
public class Objective extends IdentityObj {

    /**
     * 城市
     **/
    @TableField("city")
    private String city;

    /**
     * 省
     **/
    @TableField("province")
    private String province;

    /**
     * 区
     **/
    @TableField("region")
    private String region;

    /**
     * 薪资要求-开始
     **/
    @TableField("salary_min")
    private Integer salaryMin;

    /**
     * 薪资要求-结束
     **/
    @TableField("salary_max")
    private Integer salaryMax;

    /**
     * 工作性质
     **/
    @TableField("work_type")
    private String workType;


    /**
     * 人id
     **/
    @TableField("person_id")
    private String personId;


    /**
     * 行业
     **/
    @TableField("industry_id")
    private String industryId;

    /**
     * 行业
     **/
    @TableField("industry_name")
    private String industryName;


    /**
     * 行业
     **/
    @TableField(exist = false)
    private Person person;
}
