package com.jfb.recruit.service.impl;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jfb.recruit.mapper.ExperienceMapper;
import com.jfb.recruit.service.ExperienceService;
import data.recruit.Experience;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 招聘类型管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class ExperienceServiceImpl extends ServiceImpl<ExperienceMapper, Experience> implements ExperienceService {


    /**
     * @description: 获取所有列表
     * @author: wangmenglong
     **/
    @Override
    public List<Experience> listAll(Experience experience) {
        //创建查询条件
        LambdaQueryWrapper<Experience> qw = new LambdaQueryWrapper<>();
        qw.eq(Experience::getDel,false)
                .eq(StringUtils.isNotBlank(experience.getBaseCode()),Experience::getBaseCode, experience.getBaseCode())
                .orderByDesc(Experience::getCreateTime);
        List<Experience> orgList = super.list(qw);
        //返回查询结果
        return orgList;
    }



}
