package enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 异常码枚举
 */
@AllArgsConstructor
@Getter
public enum ExceptionCodeEnum {

    NORMAL_001("normal_001", "保存成功"),
    NORMAL_002("normal_002", "提交成功"),

    ERROR_001("error_001", "保存失败"),
    ERROR_002("error_002", "提交失败")
    ;

    private static final Map<String, ExceptionCodeEnum> CACHE = new HashMap<>(ExceptionCodeEnum.values().length);

    static {
        for (ExceptionCodeEnum value : ExceptionCodeEnum.values()) {
            CACHE.put(value.getCode(), value);
        }
    }

    private final String code;

    private final String message;

    public static ExceptionCodeEnum getByCode(String code) {
        return CACHE.get(code);
    }
}
