package com.jfb.recruit.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import data.recruit.Recruit;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * @Author: wml
 * @Date 2025/5/9 10:21
 */
public interface RecruitMapper extends BaseMapper<Recruit> {


    @Select("<script>" +
            "SELECT r.* " +
            "FROM tb_recruit r " +
            "RIGHT JOIN tb_collect rt ON r.id = rt.recruit_id " +
            "WHERE r.del = 0 and rt.del = 0 " +
            "<if test='personId != null and personId != \"\"'>" +
            "  AND rt.person_id = #{personId}" +
            "</if>" +
            "ORDER BY rt.create_time DESC" +
            "</script>")
    List<Recruit> listByCollect(@Param("personId") String personId);


    @Select("<script>" +
            "SELECT r.*,rt.person_id as personId,rt.create_time as rtTime,rt.state as recordState,rt.id as recordId " +
            "FROM tb_recruit r " +
            "RIGHT JOIN tb_sign_record rt ON r.id = rt.recruit_id " +
            "WHERE r.del = 0 and rt.del = 0 " +
            "<if test='name != null and name != \"\"'>" +
            "  AND r.name = #{name}" +
            "</if>" +
            "<if test='personId != null and personId != \"\"'>" +
            "  AND rt.person_id = #{personId}" +
            "</if>" +
            "<if test='personName != null and personName != \"\"'>" +
            "  and rt.person_id in (select id FROM tb_person where name = #{personName})" +
            "</if>" +
            "<if test='personIdno != null and personIdno != \"\"'>" +
            "  and rt.person_id in (select id FROM tb_person where id_no = #{personIdno})" +
            "</if>" +
            "<if test='adminType != null and adminType != \"admin\"'>" +
            "  and rt.recruit_id in (select id FROM tb_recruit where user_id = #{adminId})" +
            "</if>" +
            "ORDER BY rt.create_time DESC" +
            "</script>")
    List<Recruit> listBySignRecord(@Param("personId") String personId,@Param("personIdno") String personIdno,@Param("personName") String personName
            ,@Param("name") String name,@Param("adminType") String adminType,@Param("adminId") String adminId);

}
