package com.jfb.recruit.controller;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.service.PersonEducationalService;
import com.jfb.recruit.util.auth.UserUtils;
import data.recruit.PersonEducational;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author wangmenglong
 * @description: 教育经历管理
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/personEducational")
public class PersonEducationalController extends BaseController {

    @Resource
    PersonEducationalService personEducationalService;

    /**
     * @description: 获取教育经历列表
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/l")
    public BaseResult list(HttpServletRequest req,PersonEducational personEducational){
        PageInit(req);
        UserContext userContext = UserUtils.getUserContext();
        personEducational.setBaseCode(userContext.getBaseCode());
        List<PersonEducational> list = personEducationalService.list(pageNum,pageSize,personEducational);
        PageInfo<PersonEducational> pageInfo = new PageInfo<PersonEducational>(list);
        return BaseResult.success(pageInfo);
    }


    /**
    * @description: 新增教育经历
    * @author: wangmenglong
    * @param: [personEducational]
    * @return: base.result.BaseResult
    **/
    @PostMapping("/c")
    public BaseResult create(@RequestBody PersonEducational personEducational){
        //判断是否重复
        if(personEducationalService.isHave(personEducational.getSchool(),personEducational.getId())){
            return BaseResult.error("error_004");
        }
        return personEducationalService.create(personEducational)?BaseResult.success("normal_001"):BaseResult.error("error_001");
    }

    /**
     * @description: 编辑教育经历
     * @author: wangmenglong
     * @param: [personEducational]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/u")
    public BaseResult update(@RequestBody PersonEducational personEducational){
        //判断是否重复
        if(personEducationalService.isHave(personEducational.getSchool(),personEducational.getId())){
            return BaseResult.error("error_004");
        }
        return personEducationalService.update(personEducational)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
     * @description: 删除教育经历
     * @author: wangmenglong
     * @date; 2023/12/7 11:08
     * @param: [id]
     * @return: base.result.BaseResult
     **/
    @PostMapping("/d")
    public BaseResult del(@RequestBody JSONObject jsonObject){
        String id = jsonObject.getString("id");
        return personEducationalService.del(id)?BaseResult.success("normal_002"):BaseResult.error("error_002");
    }

    /**
    * @author: wangmenglong
    * @date; 2024/3/24 17:18
    * @description: 获取教育经历详情
    * @param: [id]
    * @return: base.result.BaseResult
    **/
    @GetMapping("/details")
    public BaseResult details(@RequestParam("id")String id){
        PersonEducational personEducational = personEducationalService.getDetails(id);
        return BaseResult.success(personEducational);
    }

}
