package com.jfb.recruit;

//import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
@EnableDiscoveryClient
@SpringBootApplication(scanBasePackages = {"com.jfb.recruit"})
@MapperScan(basePackages = "com.jfb.recruit.mapper")
@EnableCaching  // 开启缓存
public class JfbRecruitApplication {

    public static void main(String[] args) {
        SpringApplication.run(JfbRecruitApplication.class, args);
    }

}
