package web;

import base.result.BaseResult;
import enums.ExceptionCodeEnum;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author yuetianwang
 * @description 异常捕捉controller
 * @date 2021/7/26 17:19
 */
@Slf4j
@RestControllerAdvice
public class ExceptionCatchAdvice {

    @ExceptionHandler(Exception.class)
    @ResponseBody
    public BaseResult exceptionHandler(Exception e) {
        e.printStackTrace();
        return BaseResult.error(ExceptionCodeEnum.ERROR_002.getCode());
    }

    @ExceptionHandler(BaseException.class)
    @ResponseBody
    public BaseResult exceptionHandler(BaseException e) {
        e.printStackTrace();
        return BaseResult.error(e.getExceptionCodeEnum());
    }

    @ExceptionHandler(IllegalArgumentException.class)
    @ResponseBody
    public BaseResult exceptionHandler(IllegalArgumentException e) {
        e.printStackTrace();
        ExceptionCodeEnum exceptionCodeEnum = ExceptionCodeEnum.getByCode(e.getMessage());
        if (exceptionCodeEnum != null) {
            return BaseResult.error(exceptionCodeEnum);
        }
        return BaseResult.error(e.getMessage());
    }
}
