package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.SignRecordMapper;
import com.jfb.recruit.service.SignRecordService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.SignRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 报名管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class SignRecordServiceImpl extends ServiceImpl<SignRecordMapper, SignRecord> implements SignRecordService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
     * @description: 新增报名
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [signRecord]
     * @return: boolean
     **/
    @Override
    public String create(SignRecord signRecord) {

        signRecord.setId(snowFlakeFactory.nextId());
        signRecord.setDel(false);
        signRecord.setCreateTime(DateUtil.now());
        signRecord.setState("APPLYING");
        super.save(signRecord);
        return signRecord.getId();
    }


    /**
     * @description: 删除报名
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String recruitId,String personId) {
        if(StringUtils.isBlank(recruitId)||StringUtils.isBlank(personId)){
            return false;
        }
        LambdaUpdateWrapper<SignRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(SignRecord::getRecruitId,recruitId).eq(SignRecord::getPersonId,personId)
                .set(SignRecord::getDel,true)
                .set(SignRecord::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String recruitId, String personId) {
        LambdaQueryWrapper<SignRecord> qw = new LambdaQueryWrapper<>();
        qw.eq(SignRecord::getDel,false)
                .eq(SignRecord::getRecruitId, recruitId)
                .eq(SignRecord::getPersonId, personId);
        return super.count(qw)>0;
    }

    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 修改状态
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean update(String recordId,String state) {
        LambdaUpdateWrapper<SignRecord> qw = new LambdaUpdateWrapper<>();
        qw.eq(SignRecord::getDel,false)
                .eq(SignRecord::getId, recordId)
                .set(SignRecord::getState, state);
        return super.update(qw);
    }

}
