package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.ObjectiveIndustryMapper;
import com.jfb.recruit.service.ObjectiveIndustryService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.ObjectiveIndustry;
import data.user.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 *
 * @return: 意向行业管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class ObjectiveIndustryServiceImpl extends ServiceImpl<ObjectiveIndustryMapper, ObjectiveIndustry> implements ObjectiveIndustryService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    @Resource
    public ObjectiveIndustryMapper objectiveIndustryMapper;


    /**
     * @description: 获取意向行业列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.objectiveIndustry.ObjectiveIndustry>
     **/
    @Override
    public List<ObjectiveIndustry> listAll(ObjectiveIndustry objectiveIndustry) {
        //返回查询结果
        return objectiveIndustryMapper.listAll(objectiveIndustry.getBaseCode(),objectiveIndustry.getPersonId(),objectiveIndustry.getIndustryId());
    }


    /**
     * @description: 新增意向行业
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [objectiveIndustry]
     * @return: boolean
     **/
    @Override
    public boolean create(ObjectiveIndustry objectiveIndustry) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        objectiveIndustry.setId(snowFlakeFactory.nextId());
        objectiveIndustry.setBaseCode(baseCode);
        objectiveIndustry.setDel(false);
        objectiveIndustry.setCreateTime(DateUtil.now());

        return super.save(objectiveIndustry);
    }

    /**
     * @description: 编辑意向行业
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [objectiveIndustry]
     * @return: boolean
     **/
    @Override
    public boolean update(ObjectiveIndustry objectiveIndustry) {
        objectiveIndustry.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(objectiveIndustry.getId())){
            return false;
        }
        return super.saveOrUpdate(objectiveIndustry);
    }

    /**
     * @description: 删除意向行业
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<ObjectiveIndustry> qw = new LambdaUpdateWrapper<>();
        qw.eq(ObjectiveIndustry::getId,id)
                .set(ObjectiveIndustry::getDel,true)
                .set(ObjectiveIndustry::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取意向行业详情
     * @param: [id]
     * @return: data.objectiveIndustry.ObjectiveIndustry
     **/
    @Override
    public ObjectiveIndustry getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String personId, String industryId) {
        LambdaQueryWrapper<ObjectiveIndustry> qw = new LambdaQueryWrapper<>();
        qw.eq(ObjectiveIndustry::getDel,false)
                .eq(ObjectiveIndustry::getPersonId, personId)
                .eq(ObjectiveIndustry::getIndustryId, industryId);
        return super.count(qw)>0;
    }

}
