package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.PersonEducationalMapper;
import com.jfb.recruit.service.PersonEducationalService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.PersonEducational;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 教育经历管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class PersonEducationalServiceImpl extends ServiceImpl<PersonEducationalMapper, PersonEducational> implements PersonEducationalService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取教育经历列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.personEducational.PersonEducational>
     **/
    @Override
    public List<PersonEducational> list(int pageNum, int pageSize, PersonEducational personEducational) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<PersonEducational> qw = new LambdaQueryWrapper<>();
        qw.eq(PersonEducational::getDel,false)
                .eq(StringUtils.isNotBlank(personEducational.getBaseCode()),PersonEducational::getBaseCode, personEducational.getBaseCode())
                .eq(StringUtils.isNotBlank(personEducational.getPersonId()),PersonEducational::getPersonId, personEducational.getPersonId())
                .orderByDesc(PersonEducational::getCreateTime);
        List<PersonEducational> personEducationalList = super.list(qw);
        //返回查询结果
        return personEducationalList;
    }


    /**
     * @description: 新增教育经历
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [personEducational]
     * @return: boolean
     **/
    @Override
    public boolean create(PersonEducational personEducational) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        personEducational.setId(snowFlakeFactory.nextId());
        personEducational.setBaseCode(baseCode);
        personEducational.setDel(false);
        personEducational.setCreateTime(DateUtil.now());

        personEducational.setPersonId(userContext.getUserId());

        return super.save(personEducational);
    }

    /**
     * @description: 编辑教育经历
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [personEducational]
     * @return: boolean
     **/
    @Override
    public boolean update(PersonEducational personEducational) {
        personEducational.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(personEducational.getId())){
            return false;
        }
        return super.saveOrUpdate(personEducational);
    }

    /**
     * @description: 删除教育经历
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<PersonEducational> qw = new LambdaUpdateWrapper<>();
        qw.eq(PersonEducational::getId,id)
                .set(PersonEducational::getDel,true)
                .set(PersonEducational::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取教育经历详情
     * @param: [id]
     * @return: data.personEducational.PersonEducational
     **/
    @Override
    public PersonEducational getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String school, String id) {
        LambdaQueryWrapper<PersonEducational> qw = new LambdaQueryWrapper<>();
        qw.eq(PersonEducational::getDel,false)
                .eq(PersonEducational::getSchool, school);
        //如果传了id就是编辑，编辑的时候要加个条件，不能把名字跟别人重复
        if(StringUtils.isNotBlank(id)){
            qw.ne(PersonEducational::getId,id);
        }
        return super.count(qw)>0;
    }


    /**
     * @description: 新增教育经历
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [personEducational]
     * @return: boolean
     **/
    @Override
    public boolean createAli(PersonEducational personEducational) {

        LambdaUpdateWrapper<PersonEducational> qw = new LambdaUpdateWrapper<>();
        qw.eq(PersonEducational::getDel,false)
                .eq(PersonEducational::getPersonId, personEducational.getPersonId())
                .set(PersonEducational::getDel,true)
                .set(PersonEducational::getDelTime, DateUtil.now());
        super.update(qw);

        personEducational.setId(snowFlakeFactory.nextId());
        personEducational.setDel(false);
        personEducational.setCreateTime(DateUtil.now());

        return super.save(personEducational);
    }

}
