package com.jfb.recruit.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.jfb.recruit.bean.auth.UserContext;
import com.jfb.recruit.mapper.WorkExperienceMapper;
import com.jfb.recruit.service.WorkExperienceService;
import com.jfb.recruit.util.auth.UserUtils;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.WorkExperience;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 * @return: 工作经历管理
 * @Author: wml
 * @Date 2025/5/9 10:22
 */
@Service
@Transactional
public class WorkExperienceServiceImpl extends ServiceImpl<WorkExperienceMapper, WorkExperience> implements WorkExperienceService {

    @Autowired
    SnowFlakeFactory snowFlakeFactory;


    /**
     * @description: 获取工作经历列表
     * @author: wangmenglong
     * @date; 2023/12/11 16:46
     * @param: [pageNum, pageSize]
     * @return: java.util.List<data.workExperience.WorkExperience>
     **/
    @Override
    public List<WorkExperience> list(int pageNum, int pageSize, WorkExperience workExperience) {
        //启动分页工具
        PageHelper.startPage(pageNum, pageSize);
        //创建查询条件
        LambdaQueryWrapper<WorkExperience> qw = new LambdaQueryWrapper<>();
        qw.eq(WorkExperience::getDel,false)
                .eq(StringUtils.isNotBlank(workExperience.getBaseCode()),WorkExperience::getBaseCode, workExperience.getBaseCode())
                .eq(StringUtils.isNotBlank(workExperience.getPersonId()),WorkExperience::getPersonId, workExperience.getPersonId())
                .orderByDesc(WorkExperience::getCreateTime);
        List<WorkExperience> workExperienceList = super.list(qw);
        //返回查询结果
        return workExperienceList;
    }


    /**
     * @description: 新增工作经历
     * @author: wangmenglong
     * @date; 2023/12/11 16:51
     * @param: [workExperience]
     * @return: boolean
     **/
    @Override
    public boolean create(WorkExperience workExperience) {

        UserContext userContext = UserUtils.getUserContext();
        String baseCode = userContext.getBaseCode();

        workExperience.setId(snowFlakeFactory.nextId());
        workExperience.setBaseCode(baseCode);
        workExperience.setDel(false);
        workExperience.setCreateTime(DateUtil.now());

        workExperience.setPersonId(userContext.getUserId());

        return super.save(workExperience);
    }

    /**
     * @description: 编辑工作经历
     * @author: wangmenglong
     * @date; 2023/12/11 16:55
     * @param: [workExperience]
     * @return: boolean
     **/
    @Override
    public boolean update(WorkExperience workExperience) {
        workExperience.setUpdateTime(DateUtil.now());
        //判断是否传入id
        if(StringUtils.isBlank(workExperience.getId())){
            return false;
        }
        return super.saveOrUpdate(workExperience);
    }

    /**
     * @description: 删除工作经历
     * @author: wangmenglong
     * @date; 2023/12/11 17:06
     * @param: [id]
     * @return: boolean
     **/
    @Override
    public boolean del(String id) {
        if(StringUtils.isBlank(id)){
            return false;
        }
        LambdaUpdateWrapper<WorkExperience> qw = new LambdaUpdateWrapper<>();
        qw.eq(WorkExperience::getId,id)
                .set(WorkExperience::getDel,true)
                .set(WorkExperience::getDelTime, DateUtil.now());

        return super.update(qw);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/3/24 17:19
     * @description: 获取工作经历详情
     * @param: [id]
     * @return: data.workExperience.WorkExperience
     **/
    @Override
    public WorkExperience getDetails(String id) {
        return super.getById(id);
    }


    /**
     * @author: wangmenglong
     * @date; 2024/1/2 14:30
     * @description: 判断是否存在
     * @param: [account, id]
     * @return: boolean
     **/
    @Override
    public boolean isHave(String getOrgName, String id) {
        LambdaQueryWrapper<WorkExperience> qw = new LambdaQueryWrapper<>();
        qw.eq(WorkExperience::getDel,false)
                .eq(WorkExperience::getOrgName, getOrgName);
        //如果传了id就是编辑，编辑的时候要加个条件，不能把名字跟别人重复
        if(StringUtils.isNotBlank(id)){
            qw.ne(WorkExperience::getId,id);
        }
        return super.count(qw)>0;
    }

}
