package com.jfb.recruit.controller.api;

import base.controller.BaseController;
import base.result.BaseResult;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayConfig;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayEbppIndustryJobResumeauthlogininfoGetModel;
import com.alipay.api.internal.util.AlipayEncrypt;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayEbppIndustryJobResumeauthlogininfoGetRequest;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.response.AlipayEbppIndustryJobResumeauthlogininfoGetResponse;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import com.jfb.recruit.xsnowflake.SnowFlakeFactory;
import data.recruit.Person;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * @author wangmenglong
 * @description: 阿里调用
 * @date 2023/12/11 11:35
 */
@RestController
@RequestMapping("/public/ali")
public class ApiAliController extends BaseController {

    public static String appId = "2021005184646262";
    public static String privateKey  = "MIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQC/aljGWqc80Fx82woJVQ1sIhe8+//6h4Bmec1L6C4Ubrz/XoHfH0Ih61kX5mVHiaGBLGdYJdv3AzZxim/vns0upfo+Nx9adVvT6iZBixbIcJuakaTF2xtcPhh6N3OjEzWUg2LwB4u2xTp1px3PPQrXTK/WbmYWrunE5Qn5A/38VwQszz++A9FvDKeFxrTiNuhmyee+wakoJVrd5NhiGRkZwEZYM0Ggj63OD4Jjw58cwv4sdE/BIzQG5YK1Tw+1VzYHcY3a2oLshe3ad5HQdwb8RGTMaqRVk3UuInUZ80BeUfR6k2KOI/u7vXzxVns56n8V8mHAyKLYBpGqS/oZhvDzAgMBAAECggEATUJLWqQ0ZCNlcS+nuWSO6lpIYosEIsaWWMZIyp6IGs8nkZs/qCMhujcX2sGvl1RBz7VwcO+2/NhbHTDXRUw/XNi5TGtLSGOeEMatcj8FjxmEdLrcWs+5F14o2wuOrP+P3MW7JU6mYbrxgZNWQNNOkN/vCQm+QuGOkV4wzEWEOljhACXU9VOVGF24yfBdp+SI0RhSCEVQDWesGRRYM0CDY4nOXcltzOqqoIBeE08ecJWO9Wt8a5/E0oOBWnuO9Vn3VL5Ss/nmW0kMClo1+iWNjqFYbmDCLR7eGP+Kl6AfoWUWRNronZ8UOHWCyzhpLxXOgAuUMPGwyKNGYVFiZ3pv4QKBgQD4ZYbhJSWiqsbUHlqcXIhuOwR2pBcMu/pzrRs+Y0JDz/x1B65WIEvAA0YDf8XQVk++g0O/M0+lXrsRcaCJ7ZmJue/61RggdGBXDwtCLOqKZbs4lvwmPAfsAyCnMgtpYZRUlXLTh8yC/kJv1WdOiyrlAopuyuT1R37M4IZVA615ZQKBgQDFRk6NfC1m5igpWNsCLt5vH1V1H9wyjwK+nQ9FJLsg+Ah5P+ANFHzW4gYX1+bfnhzZR02UoJmGMheXVl7g+d0Pw/KeHEidLvLsCx7id/bKquilB8dyUDIemJ9dVyzerRqc+Q1h19obBhZA3AdxXKaeFXnym2busZbqGba+Ww7HdwKBgCJvCJSbbq0vGWL8VjlIxozpV4QO2Tcls+FnRNiQL/ZwlaGvj+ZWkcmraoA/rS9lV6akUbbmqQrWp/4SD1wveNJT2UWfVrnhCB3pcvkYeub2lU6R96BhQAPipxsmX9ia81IKaaGTOLGMB6+zGKAVwLuAb6pOLBEoeRZzpYuRd/HVAoGBAMATfnRfzcz8l2n6q/LqM4U6mvhZNwq7F88EGVQXOWQWXBnCSaIyqoKGu6wHeTGNP0WHGVB3NkPlDfc6D1M5tTWeceHkZAc3KSsOgNm8ODyIP9A/TMBOuR31OGWndXayUNE55P+5LRFW0eAA2/ZSYaBWBNBk4snRe8EfnECnZDJtAoGBAMLZzmrQ5knaT0HID05axZwts+BM9aYkyHPkzfOlLnLTsS7w7e0mJhyihnJXQStzl0ihOSY+8ox8u+A9qYjiEROnc3MUFe7UAqk9lSSHd2D16sqT1MOhhXmwJ9/Ftb2GjYzfRK2Gi1V46UWnLpWIihWxT1Eh9AUgagqbcFRaResy";
    public static String alipayPublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjTYSicJWsQC+D4yqZdhs8Ew1gepk56+pK5zgF3I+Z/OoaiEZ1gKdeC37c1d4Xzh9tK4+74JRN6LVSSK+83zsUBZfJPOf9vssV/uDvbxniQ+SHHgNZEkfpgOTbWpckJJlHDTQNS9gwVF+uLDa2++9mHx+fUpC6iQBljsY42JpJ2kW0HGbkHnjNwkJMmJeqbEJcLynKkAxOKhkoOIIuGLhJtnsW3RlpRB6z9kZHhi26p5GYT3j8RhEKYUGnuav2T5W/eq074jD4oInDT2vnWZT6Q3ardhUJzeQZCMX6Gxa9wphNEFHixp3CYV4dUOkQ4nsdAYN8tdTG4oWQLLbJQcDPQIDAQAB";
    public static String decryptKey = "+RWPnjKz2WzhE2pa7lx4Ag==";


    @Autowired
    SnowFlakeFactory snowFlakeFactory;

    /**
     * @description: 获取openId
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @GetMapping("/getopenId")
    public BaseResult getopenId(HttpServletRequest req)throws AlipayApiException{

        String code = req.getParameter("code");

        // 初始化SDK
        AlipayClient alipayClient = new DefaultAlipayClient(getAlipayConfig());

        // 构造请求参数以调用接口
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();

        // 设置刷新令牌
        //request.setRefreshToken("201208134b203fe6c11548bcabd8da5bb087a83b");

        // 设置授权码
        request.setCode(code);

        // 设置授权方式
        request.setGrantType("authorization_code");

        AlipaySystemOauthTokenResponse response = alipayClient.execute(request);
        System.out.println(response.getBody());

        if (response.isSuccess()) {
            System.out.println("调用成功");
        } else {
            System.out.println("调用失败");
        }


        return BaseResult.success(response.getBody());
    }

    /**
     * @description: 获取手机号
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @PostMapping("/getPhone")
    public BaseResult getPhone(@RequestBody JSONObject jsonObject)throws Exception{

        String sign = jsonObject.getString("sign");
        String content = jsonObject.getString("response");
        //1. 获取验签和解密所需要的参数
        String signType = "RSA2";
        String charset = "UTF-8";
        String encryptType = "AES";
        //判断是否为加密内容
        boolean isDataEncrypted = !content.startsWith("{");
        boolean signCheckPass = false;
        //2. 验签
        String signContent = content;
        String signVeriKey = alipayPublicKey;
        //String decryptKey = decryptKey;
        if (isDataEncrypted) {
            signContent = "\"" + signContent + "\"";
        } try {
            signCheckPass = AlipaySignature.rsaCheck(signContent, sign, signVeriKey, charset, signType);
        } catch (AlipayApiException e) {
            // 验签异常, 日志
        } if (!signCheckPass) {
            //验签不通过（异常或者报文被篡改），终止流程（不需要做解密）
            throw new Exception("验签失败");
        }
        //3. 解密
        String plainData = null;
        if (isDataEncrypted) {
            try {
                plainData = AlipayEncrypt.decryptContent(content, encryptType, decryptKey, charset);
            } catch (AlipayApiException e) {
                //解密异常, 记录日志
                throw new Exception("解密异常");
            }
        } else {
            plainData = content;
        }


        return BaseResult.success(plainData);
    }


    /**
     * @description: 获取安心工作证
     * @author: wangmenglong
     * @date; 2023/12/7 10:07
     * @param: [req]
     * @return: com.github.pagehelper.PageInfo
     **/
    @PostMapping("/info/get")
    public BaseResult infoGet(@RequestBody JSONObject jsonObject)throws Exception{


        // 初始化SDK
        AlipayClient alipayClient = new DefaultAlipayClient(getAlipayConfig());

        // 构造请求参数以调用接口
        AlipayEbppIndustryJobResumeauthlogininfoGetRequest request = new AlipayEbppIndustryJobResumeauthlogininfoGetRequest();
        AlipayEbppIndustryJobResumeauthlogininfoGetModel model = new AlipayEbppIndustryJobResumeauthlogininfoGetModel();

        // 设置业务token
        model.setBizToken(jsonObject.getString("biz_token"));

        request.setBizModel(model);
        // 第三方代调用模式下请设置app_auth_token
        // request.putOtherTextParam("app_auth_token", "<-- 请填写应用授权令牌 -->");

        AlipayEbppIndustryJobResumeauthlogininfoGetResponse response = alipayClient.execute(request);
        System.out.println(response.getBody());

        if (response.isSuccess()) {
            System.out.println("调用成功");
        } else {
            System.out.println("调用失败");
            // sdk版本是"4.38.0.ALL"及以上,可以参考下面的示例获取诊断链接
            // String diagnosisUrl = DiagnosisUtils.getDiagnosisUrl(response);
            // System.out.println(diagnosisUrl);
        }

        return BaseResult.success(response.getBody());
    }


    @RequestMapping(value  =  "/isv/spi/service")
    @ResponseBody
    public String spiService(@RequestParam Map<String, String> params, @RequestHeader Map<String, String> headers) throws Exception{
        // http响应结果载体
        JSONObject result = new JSONObject();
        // 业务处理结果载体
        JSONObject response = new JSONObject();
        // 1、验签支付宝请求报文
        boolean isPass = false;

        // 提取spi接口定义的header参数,接口定义所有参数都需要参与验签（接口没有定义header参数则忽略这一步）
        String spiHeader = headers.get("spi_header");
        params.put("spi_header", spiHeader);

        isPass = AlipaySignature.rsaCheckV1(params, alipayPublicKey, "UTF-8", "RSA2");
        if(isPass) {
            // 2、验签成功：处理业务逻辑，并构造业务处理结果
            response.put("code", "10000");
            response.put("msg", "Success");
            response.put("out_apply_id", snowFlakeFactory.nextId());
        } else {
            // 3、验签失败：构造错误码
            response.put("code", "40004");
            response.put("msg", "Business Failed");
            response.put("sub_code", "ISV-VERIFICATION-FAILED");
            response.put("sub_msg", "验签失败");
        }
        // 4、业务处理结果加签 （可选，查看 服务基础配置 章节）
        // contentToSign为 {"code":"10000","msg":"Success","biz":"value","person":{"age":"18","height":"180"}}
        String contentToSign = response.toJSONString();
        String sign = null;
        sign = AlipaySignature.rsaSign(contentToSign, privateKey, "UTF-8", "RSA2");
        // 5、构造http响应结果
        result.put("sign", sign);
        //可选，查看 服务基础配置
        result.put("response", response);
        // 返回json格式响应报文
        return result.toJSONString();
    }


    public static AlipayConfig getAlipayConfig() {
        AlipayConfig alipayConfig = new AlipayConfig();
        //alipayConfig.setServerUrl("https://openapipre.alipay.com/gateway.do");   //测试
        alipayConfig.setServerUrl("https://openapi.alipay.com/gateway.do");  //正式
        alipayConfig.setAppId(appId);
        alipayConfig.setPrivateKey(privateKey);
        alipayConfig.setFormat("json");
        alipayConfig.setAlipayPublicKey(alipayPublicKey);
        alipayConfig.setCharset("UTF-8");
        alipayConfig.setSignType("RSA2");
        return alipayConfig;
    }

}
