package com.jfb.recruit.util.auth;

import com.alibaba.fastjson.JSONObject;
import com.jfb.recruit.bean.auth.SelfUserEntity;
import com.jfb.recruit.bean.auth.UserContext;
import org.springframework.security.core.context.SecurityContextHolder;

/**
 * @Author zhangziyuan
 * @Description
 * @Date 2021/7/16
 **/
public class UserUtils {

    public static JSONObject getCurrentUser(){
        SelfUserEntity principal = (SelfUserEntity) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("username",principal.getUsername());
        jsonObject.put("userid",principal.getUserId());
        jsonObject.put("baseCode",principal.getBaseCode());
        jsonObject.put("type",principal.getAuthorities().toArray()[0].toString().split("_")[1]);
        return jsonObject;
    }

    /**
     * 获取登录用户上下文
     *
     * @return
     */
    public static UserContext getUserContext() {
        SelfUserEntity principal = (SelfUserEntity) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        UserContext userContext = new UserContext();
        userContext.setUserId(principal.getUserId());
        userContext.setAccount(principal.getUsername());
        userContext.setBaseCode(principal.getBaseCode());
        userContext.setType(principal.getType());
        userContext.setRoleId(principal.getRoleId());
        userContext.setIdNo(principal.getIdNo());
        userContext.setUsername(principal.getName());
        userContext.setRoleTag(principal.getRoleTag());
        userContext.setPhone(principal.getPhone());
        userContext.setOpenId(principal.getOpenId());
        userContext.setSuperAdmin(principal.getSuperAdmin());
        return userContext;
    }

    /**
     * 获取登录用户上下文
     * @return
     */
    public static SelfUserEntity getSelfUserEntity() {
        SelfUserEntity principal = (SelfUserEntity) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return principal;
    }
}
